/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase.scope;

import ai.timefold.solver.core.impl.phase.scope.AbstractMoveScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import java.util.ArrayList;
import java.util.Objects;

public record SolverLifecyclePoint(int moveThreadIndex, int phaseIndex, int stepIndex, int moveIndex, String treeId) {
    public static SolverLifecyclePoint of(AbstractMoveScope<?> moveScope) {
        AbstractStepScope<?> stepScope = moveScope.getStepScope();
        return new SolverLifecyclePoint(-1, stepScope.getPhaseScope().getPhaseIndex(), stepScope.getStepIndex(), moveScope.moveIndex, null);
    }

    public static SolverLifecyclePoint of(AbstractStepScope<?> stepScope, String treeId) {
        return new SolverLifecyclePoint(-1, stepScope.getPhaseScope().getPhaseIndex(), stepScope.getStepIndex(), -1, Objects.requireNonNull(treeId));
    }

    public static SolverLifecyclePoint of(int moveThreadIndex, int phaseIndex, int stepIndex, int moveIndex) {
        return new SolverLifecyclePoint(moveThreadIndex, phaseIndex, stepIndex, moveIndex, null);
    }

    @Override
    public String toString() {
        ArrayList<String> stringList = new ArrayList<String>();
        stringList.add("Phase index (%d)".formatted(this.phaseIndex));
        if (this.moveThreadIndex >= 0) {
            stringList.add("move thread index (%d)".formatted(this.moveThreadIndex));
        }
        stringList.add("step index (%d)".formatted(this.stepIndex));
        if (this.moveIndex == -1) {
            stringList.add("move tree id (%s)".formatted(this.treeId));
        } else {
            stringList.add("move index (%d)".formatted(this.moveIndex));
        }
        return String.join((CharSequence)", ", stringList) + ".";
    }
}

