/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;

public class ListChangeMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, ListChangeMoveSelectorConfig> {
    public ListChangeMoveSelectorFactory(ListChangeMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ValueSelectorConfig valueSelectorConfig = ListChangeMoveSelectorFactory.checkUnfolded("valueSelectorConfig", ((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig());
        DestinationSelectorConfig destinationSelectorConfig = ListChangeMoveSelectorFactory.checkUnfolded("destinationSelectorConfig", ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig());
        EntitySelectorConfig destinationEntitySelectorConfig = ListChangeMoveSelectorFactory.checkUnfolded("destinationEntitySelectorConfig", destinationSelectorConfig.getEntitySelectorConfig());
        ListChangeMoveSelectorFactory.checkUnfolded("destinationValueSelectorConfig", destinationSelectorConfig.getValueSelectorConfig());
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntityDescriptor entityDescriptor = EntitySelectorFactory.create(destinationEntitySelectorConfig).extractEntityDescriptor(configPolicy);
        ValueSelector sourceValueSelector = ValueSelectorFactory.create(valueSelectorConfig).buildValueSelector(configPolicy, entityDescriptor, minimumCacheType, selectionOrder);
        if (!(sourceValueSelector instanceof EntityIndependentValueSelector)) {
            throw new IllegalArgumentException("The listChangeMoveSelector (%s) for a list variable needs to be based on an %s (%s).\nCheck your valueSelectorConfig.".formatted(this.config, EntityIndependentValueSelector.class.getSimpleName(), sourceValueSelector));
        }
        EntityIndependentValueSelector castSourceValueSelector = (EntityIndependentValueSelector)sourceValueSelector;
        DestinationSelector destinationSelector = DestinationSelectorFactory.create(destinationSelectorConfig).buildDestinationSelector(configPolicy, minimumCacheType, randomSelection);
        return new ListChangeMoveSelector(castSourceValueSelector, destinationSelector, randomSelection);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        GenuineVariableDescriptor onlyDestinationVariableDescriptor;
        Collection entityDescriptors;
        DestinationSelectorConfig destinationSelectorConfig = ((ListChangeMoveSelectorConfig)this.config).getDestinationSelectorConfig();
        EntitySelectorConfig destinationEntitySelectorConfig = destinationSelectorConfig == null ? null : destinationSelectorConfig.getEntitySelectorConfig();
        EntityDescriptor onlyEntityDescriptor = destinationEntitySelectorConfig == null ? null : EntitySelectorFactory.create(destinationEntitySelectorConfig).extractEntityDescriptor(configPolicy);
        Collection collection = entityDescriptors = onlyEntityDescriptor == null ? configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors() : Collections.singletonList(onlyEntityDescriptor);
        if (entityDescriptors.size() > 1) {
            throw new IllegalArgumentException("The listChangeMoveSelector (%s) cannot unfold when there are multiple entities (%s).\nPlease use one listChangeMoveSelector per each planning list variable.".formatted(this.config, entityDescriptors));
        }
        EntityDescriptor entityDescriptor = entityDescriptors.iterator().next();
        ArrayList<ListVariableDescriptor> variableDescriptorList = new ArrayList<ListVariableDescriptor>();
        ValueSelectorConfig valueSelectorConfig = ((ListChangeMoveSelectorConfig)this.config).getValueSelectorConfig();
        GenuineVariableDescriptor onlyVariableDescriptor = valueSelectorConfig == null ? null : ValueSelectorFactory.create(valueSelectorConfig).extractVariableDescriptor(configPolicy, entityDescriptor);
        ValueSelectorConfig destinationValueSelectorConfig = destinationSelectorConfig == null ? null : destinationSelectorConfig.getValueSelectorConfig();
        GenuineVariableDescriptor genuineVariableDescriptor = onlyDestinationVariableDescriptor = destinationValueSelectorConfig == null ? null : ValueSelectorFactory.create(destinationValueSelectorConfig).extractVariableDescriptor(configPolicy, entityDescriptor);
        if (onlyVariableDescriptor != null && onlyDestinationVariableDescriptor != null) {
            if (!onlyVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The listChangeMoveSelector (%s) is configured to use a planning variable (%s), which is not a planning list variable.\nEither fix your annotations and use a @%s on the variable to make it work with listChangeMoveSelector\nor use a changeMoveSelector instead.".formatted(this.config, onlyVariableDescriptor, PlanningListVariable.class.getSimpleName()));
            }
            if (!onlyDestinationVariableDescriptor.isListVariable()) {
                throw new IllegalArgumentException("The destinationSelector (%s) is configured to use a planning variable (%s), which is not a planning list variable.".formatted(destinationSelectorConfig, onlyDestinationVariableDescriptor));
            }
            if (onlyVariableDescriptor != onlyDestinationVariableDescriptor) {
                throw new IllegalArgumentException("The listChangeMoveSelector's valueSelector (%s) and destinationSelector's valueSelector (%s) must be configured for the same planning variable.".formatted(valueSelectorConfig, destinationValueSelectorConfig));
            }
            if (onlyEntityDescriptor != null) {
                return null;
            }
            variableDescriptorList.add((ListVariableDescriptor)onlyVariableDescriptor);
        } else {
            variableDescriptorList.addAll(entityDescriptor.getGenuineVariableDescriptorList().stream().filter(VariableDescriptor::isListVariable).map(variableDescriptor -> (ListVariableDescriptor)variableDescriptor).toList());
        }
        if (variableDescriptorList.isEmpty()) {
            throw new IllegalArgumentException("The listChangeMoveSelector (%s) cannot unfold because there are no planning list variables.".formatted(this.config));
        }
        if (variableDescriptorList.size() > 1) {
            throw new IllegalArgumentException("The listChangeMoveSelector (%s) cannot unfold because there are multiple planning list variables.".formatted(this.config));
        }
        ListChangeMoveSelectorConfig listChangeMoveSelectorConfig = ListChangeMoveSelectorFactory.buildChildMoveSelectorConfig((ListVariableDescriptor)variableDescriptorList.get(0), valueSelectorConfig, destinationSelectorConfig);
        listChangeMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return listChangeMoveSelectorConfig;
    }

    public static ListChangeMoveSelectorConfig buildChildMoveSelectorConfig(ListVariableDescriptor<?> variableDescriptor, ValueSelectorConfig inheritedValueSelectorConfig, DestinationSelectorConfig inheritedDestinationSelectorConfig) {
        ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(inheritedValueSelectorConfig);
        if (childValueSelectorConfig.getMimicSelectorRef() == null) {
            childValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
        }
        return new ListChangeMoveSelectorConfig().withValueSelectorConfig(childValueSelectorConfig).withDestinationSelectorConfig(new DestinationSelectorConfig(inheritedDestinationSelectorConfig).withEntitySelectorConfig(Optional.ofNullable(inheritedDestinationSelectorConfig).map(DestinationSelectorConfig::getEntitySelectorConfig).map(EntitySelectorConfig::new).orElseGet(EntitySelectorConfig::new).withEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass())).withValueSelectorConfig(Optional.ofNullable(inheritedDestinationSelectorConfig).map(DestinationSelectorConfig::getValueSelectorConfig).map(ValueSelectorConfig::new).orElseGet(ValueSelectorConfig::new).withVariableName(variableDescriptor.getVariableName())));
    }
}

