/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.factory;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.move.factory.MoveListFactoryConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.factory.MoveListFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.factory.MoveListFactoryToMoveSelectorBridge;

public class MoveListFactoryFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, MoveListFactoryConfig> {
    public MoveListFactoryFactory(MoveListFactoryConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    public MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        Class<? extends MoveListFactory> moveListFactoryClass = ((MoveListFactoryConfig)this.config).getMoveListFactoryClass();
        if (moveListFactoryClass == null) {
            throw new IllegalArgumentException("The moveListFactoryConfig (%s) lacks a moveListFactoryClass (%s).".formatted(this.config, moveListFactoryClass));
        }
        MoveListFactory moveListFactory = ConfigUtils.newInstance(this.config, "moveListFactoryClass", moveListFactoryClass);
        ConfigUtils.applyCustomProperties(moveListFactory, "moveListFactoryClass", ((MoveListFactoryConfig)this.config).getMoveListFactoryCustomProperties(), "moveListFactoryCustomProperties");
        if (minimumCacheType.compareTo(SelectionCacheType.STEP) < 0) {
            minimumCacheType = SelectionCacheType.STEP;
        }
        return new MoveListFactoryToMoveSelectorBridge(moveListFactory, minimumCacheType, randomSelection);
    }

    @Override
    protected boolean isBaseInherentlyCached() {
        return true;
    }
}

