/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.cascade.CascadingUpdateShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSession;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultShadowVariableSessionFactory;
import ai.timefold.solver.core.impl.domain.variable.declarative.DefaultTopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.InverseRelationShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.SourcedVariableListener;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.listener.support.AbstractNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.BasicVariableNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableChangedNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.NotifiableRegistry;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.violation.ShadowVariablesAssert;
import ai.timefold.solver.core.impl.domain.variable.nextprev.NextElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.nextprev.PreviousElementShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.Demand;
import ai.timefold.solver.core.impl.domain.variable.supply.Supply;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.util.LinkedIdentityHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.IntFunction;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

@NullMarked
public final class VariableListenerSupport<Solution_>
implements SupplyManager {
    private static final int SHADOW_VARIABLE_VIOLATION_DISPLAY_LIMIT = 3;
    private final InnerScoreDirector<Solution_, ?> scoreDirector;
    private final NotifiableRegistry<Solution_> notifiableRegistry;
    private final Map<Demand<?>, SupplyWithDemandCount> supplyMap = new HashMap();
    private final @Nullable ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final List<ListVariableChangedNotification<Solution_>> listVariableChangedNotificationList;
    private final Set<Object> unassignedValueWithEmptyInverseEntitySet;
    private final List<CascadingUpdateShadowVariableDescriptor<Solution_>> cascadingUpdateShadowVarDescriptorList;
    private final @NonNull IntFunction<TopologicalOrderGraph> shadowVariableGraphCreator;
    private boolean notificationQueuesAreEmpty = true;
    private int nextGlobalOrder = 0;
    private @Nullable DefaultShadowVariableSession<Solution_> shadowVariableSession = null;
    private @Nullable ListVariableStateSupply<Solution_> listVariableStateSupply = null;

    public static <Solution_> VariableListenerSupport<Solution_> create(InnerScoreDirector<Solution_, ?> scoreDirector) {
        return new VariableListenerSupport<Solution_>(scoreDirector, new NotifiableRegistry<Solution_>(scoreDirector.getSolutionDescriptor()), TimefoldSolverEnterpriseService.buildOrDefault(service -> service::buildTopologyGraph, () -> DefaultTopologicalOrderGraph::new));
    }

    VariableListenerSupport(InnerScoreDirector<Solution_, ?> scoreDirector, NotifiableRegistry<Solution_> notifiableRegistry, @NonNull IntFunction<TopologicalOrderGraph> shadowVariableGraphCreator) {
        this.scoreDirector = Objects.requireNonNull(scoreDirector);
        this.notifiableRegistry = Objects.requireNonNull(notifiableRegistry);
        this.listVariableDescriptor = scoreDirector.getSolutionDescriptor().getListVariableDescriptor();
        this.cascadingUpdateShadowVarDescriptorList = this.listVariableDescriptor != null ? scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().flatMap(e -> e.getDeclaredCascadingUpdateShadowVariableDescriptors().stream()).toList() : Collections.emptyList();
        boolean hasCascadingUpdates = !this.cascadingUpdateShadowVarDescriptorList.isEmpty();
        this.listVariableChangedNotificationList = new ArrayList<ListVariableChangedNotification<Solution_>>();
        this.unassignedValueWithEmptyInverseEntitySet = hasCascadingUpdates ? new LinkedIdentityHashSet() : Collections.emptySet();
        this.shadowVariableGraphCreator = shadowVariableGraphCreator;
    }

    public void linkVariableListeners() {
        this.listVariableStateSupply = this.listVariableDescriptor == null ? null : (ListVariableStateSupply)this.demand(this.listVariableDescriptor.getStateDemand());
        this.scoreDirector.getSolutionDescriptor().getEntityDescriptors().stream().map(EntityDescriptor::getDeclaredShadowVariableDescriptors).flatMap(Collection::stream).filter(ShadowVariableDescriptor::hasVariableListener).sorted(Comparator.comparingInt(ShadowVariableDescriptor::getGlobalShadowOrder)).forEach(d -> {
            if (this.listVariableStateSupply == null) {
                this.processShadowVariableDescriptorWithoutListVariable((ShadowVariableDescriptor<Solution_>)d);
            } else {
                this.processShadowVariableDescriptorWithListVariable((ShadowVariableDescriptor<Solution_>)d, this.listVariableStateSupply);
            }
        });
    }

    private void processShadowVariableDescriptorWithListVariable(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor, ListVariableStateSupply<Solution_> listVariableStateSupply) {
        if (shadowVariableDescriptor instanceof IndexShadowVariableDescriptor) {
            IndexShadowVariableDescriptor indexShadowVariableDescriptor = (IndexShadowVariableDescriptor)shadowVariableDescriptor;
            listVariableStateSupply.externalize(indexShadowVariableDescriptor);
        } else if (shadowVariableDescriptor instanceof InverseRelationShadowVariableDescriptor) {
            InverseRelationShadowVariableDescriptor inverseRelationShadowVariableDescriptor = (InverseRelationShadowVariableDescriptor)shadowVariableDescriptor;
            listVariableStateSupply.externalize(inverseRelationShadowVariableDescriptor);
        } else if (shadowVariableDescriptor instanceof PreviousElementShadowVariableDescriptor) {
            PreviousElementShadowVariableDescriptor previousElementShadowVariableDescriptor = (PreviousElementShadowVariableDescriptor)shadowVariableDescriptor;
            listVariableStateSupply.externalize(previousElementShadowVariableDescriptor);
        } else if (shadowVariableDescriptor instanceof NextElementShadowVariableDescriptor) {
            NextElementShadowVariableDescriptor nextElementShadowVariableDescriptor = (NextElementShadowVariableDescriptor)shadowVariableDescriptor;
            listVariableStateSupply.externalize(nextElementShadowVariableDescriptor);
        } else {
            this.processShadowVariableDescriptorWithoutListVariable(shadowVariableDescriptor);
        }
    }

    private void processShadowVariableDescriptorWithoutListVariable(ShadowVariableDescriptor<Solution_> shadowVariableDescriptor) {
        for (VariableListenerWithSources<Solution_> listenerWithSources : shadowVariableDescriptor.buildVariableListeners(this)) {
            AbstractVariableListener<Solution_, Object> variableListener = listenerWithSources.getVariableListener();
            if (variableListener instanceof Supply) {
                Supply supply = (Supply)((Object)variableListener);
                Demand<?> demand = shadowVariableDescriptor.getProvidedDemand();
                this.supplyMap.put(demand, new SupplyWithDemandCount(supply, 1L));
            }
            int globalOrder = shadowVariableDescriptor.getGlobalShadowOrder();
            this.notifiableRegistry.registerNotifiable(listenerWithSources.getSourceVariableDescriptors(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, globalOrder));
            this.nextGlobalOrder = globalOrder + 1;
        }
    }

    @Override
    public <Supply_ extends Supply> Supply_ demand(Demand<Supply_> demand) {
        SupplyWithDemandCount supplyWithDemandCount = this.supplyMap.get(demand);
        if (supplyWithDemandCount == null) {
            SupplyWithDemandCount newSupplyWithDemandCount = new SupplyWithDemandCount(this.createSupply(demand), 1L);
            this.supplyMap.put(demand, newSupplyWithDemandCount);
            return (Supply_)newSupplyWithDemandCount.supply;
        }
        Supply supply = supplyWithDemandCount.supply;
        SupplyWithDemandCount newSupplyWithDemandCount = new SupplyWithDemandCount(supply, supplyWithDemandCount.demandCount + 1L);
        this.supplyMap.put(demand, newSupplyWithDemandCount);
        return (Supply_)supply;
    }

    private Supply createSupply(Demand<?> demand) {
        Object supply = demand.createExternalizedSupply(this);
        if (supply instanceof SourcedVariableListener) {
            SourcedVariableListener variableListener = (SourcedVariableListener)supply;
            if (this.scoreDirector.getWorkingSolution() != null) {
                variableListener.resetWorkingSolution(this.scoreDirector);
            }
            this.notifiableRegistry.registerNotifiable(variableListener.getSourceVariableDescriptor(), AbstractNotifiable.buildNotifiable(this.scoreDirector, variableListener, this.nextGlobalOrder++));
        }
        return supply;
    }

    @Override
    public <Supply_ extends Supply> boolean cancel(Demand<Supply_> demand) {
        SupplyWithDemandCount supplyWithDemandCount = this.supplyMap.get(demand);
        if (supplyWithDemandCount == null) {
            return false;
        }
        if (supplyWithDemandCount.demandCount == 1L) {
            this.supplyMap.remove(demand);
        } else {
            this.supplyMap.put(demand, new SupplyWithDemandCount(supplyWithDemandCount.supply, supplyWithDemandCount.demandCount - 1L));
        }
        return true;
    }

    @Override
    public <Supply_ extends Supply> long getActiveCount(Demand<Supply_> demand) {
        SupplyWithDemandCount supplyAndDemandCounter = this.supplyMap.get(demand);
        if (supplyAndDemandCounter == null) {
            return 0L;
        }
        return supplyAndDemandCounter.demandCount;
    }

    public void resetWorkingSolution() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.resetWorkingSolution();
        }
        if (!this.scoreDirector.getSolutionDescriptor().getDeclarativeShadowVariableDescriptors().isEmpty()) {
            DefaultShadowVariableSessionFactory shadowVariableSessionFactory = new DefaultShadowVariableSessionFactory(this.scoreDirector.getSolutionDescriptor(), this.scoreDirector, this.shadowVariableGraphCreator);
            this.shadowVariableSession = shadowVariableSessionFactory.forSolution(this.scoreDirector.getWorkingSolution());
            this.triggerVariableListenersInNotificationQueues();
        }
    }

    public void close() {
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.closeVariableListener();
        }
    }

    public void beforeEntityAdded(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityAdded(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeEntityRemoved(EntityDescriptor<Solution_> entityDescriptor, Object entity) {
        Collection<EntityNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(entityDescriptor);
        if (!notifiables.isEmpty()) {
            EntityNotification notification = Notification.entityRemoved(entity);
            for (EntityNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void beforeVariableChanged(VariableDescriptor<Solution_> variableDescriptor, Object entity) {
        Collection<VariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            BasicVariableNotification notification = Notification.variableChanged(entity);
            for (VariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
        if (this.shadowVariableSession != null) {
            this.shadowVariableSession.beforeVariableChanged(variableDescriptor, entity);
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void afterElementUnassigned(ListVariableDescriptor<Solution_> variableDescriptor, Object element) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableNotification notification = Notification.elementUnassigned(element);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyAfter(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
        if (!this.cascadingUpdateShadowVarDescriptorList.isEmpty()) {
            this.unassignedValueWithEmptyInverseEntitySet.add(element);
        }
    }

    public void beforeListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        if (!notifiables.isEmpty()) {
            ListVariableChangedNotification notification = Notification.listVariableChanged(entity, fromIndex, toIndex);
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyBefore(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
    }

    public void afterListVariableChanged(ListVariableDescriptor<Solution_> variableDescriptor, Object entity, int fromIndex, int toIndex) {
        Collection<ListVariableListenerNotifiable<Solution_>> notifiables = this.notifiableRegistry.get(variableDescriptor);
        ListVariableChangedNotification notification = Notification.listVariableChanged(entity, fromIndex, toIndex);
        if (!notifiables.isEmpty()) {
            for (ListVariableListenerNotifiable notifiable : notifiables) {
                notifiable.notifyAfter(notification);
            }
            this.notificationQueuesAreEmpty = false;
        }
        if (!this.cascadingUpdateShadowVarDescriptorList.isEmpty()) {
            this.listVariableChangedNotificationList.add(notification);
        }
    }

    public InnerScoreDirector<Solution_, ?> getScoreDirector() {
        return this.scoreDirector;
    }

    public void triggerVariableListenersInNotificationQueues() {
        if (this.notificationQueuesAreEmpty) {
            return;
        }
        for (Notifiable notifiable : this.notifiableRegistry.getAll()) {
            notifiable.triggerAllNotifications();
        }
        if (this.listVariableDescriptor != null) {
            if (!(this.cascadingUpdateShadowVarDescriptorList.isEmpty() || this.listVariableChangedNotificationList.isEmpty() && this.unassignedValueWithEmptyInverseEntitySet.isEmpty())) {
                this.triggerCascadingUpdateShadowVariableUpdate();
            }
            this.listVariableChangedNotificationList.clear();
        }
        if (this.shadowVariableSession != null) {
            this.shadowVariableSession.updateVariables();
        }
        this.notificationQueuesAreEmpty = true;
    }

    private void triggerCascadingUpdateShadowVariableUpdate() {
        if (this.listVariableChangedNotificationList.isEmpty() || this.cascadingUpdateShadowVarDescriptorList.isEmpty()) {
            return;
        }
        for (CascadingUpdateShadowVariableDescriptor<Solution_> cascadingUpdateShadowVariableDescriptor : this.cascadingUpdateShadowVarDescriptorList) {
            this.cascadeListVariableChangedNotifications(cascadingUpdateShadowVariableDescriptor);
            this.cascadeUnassignedValues(cascadingUpdateShadowVariableDescriptor);
        }
        this.unassignedValueWithEmptyInverseEntitySet.clear();
    }

    private void cascadeListVariableChangedNotifications(CascadingUpdateShadowVariableDescriptor<Solution_> cascadingUpdateShadowVariableDescriptor) {
        for (ListVariableChangedNotification<Solution_> notification : this.listVariableChangedNotificationList) {
            this.cascadeListVariableValueUpdates((List<Object>)this.listVariableDescriptor.getValue(notification.getEntity()), notification.getFromIndex(), notification.getToIndex(), cascadingUpdateShadowVariableDescriptor);
        }
    }

    private void cascadeListVariableValueUpdates(List<Object> values, int fromIndex, int toIndex, CascadingUpdateShadowVariableDescriptor<Solution_> cascadingUpdateShadowVariableDescriptor) {
        for (int currentIndex = fromIndex; currentIndex < values.size(); ++currentIndex) {
            boolean forceUpdate;
            Object value = values.get(currentIndex);
            this.unassignedValueWithEmptyInverseEntitySet.remove(value);
            boolean bl = forceUpdate = currentIndex < toIndex;
            if (!cascadingUpdateShadowVariableDescriptor.update(this.scoreDirector, value) && !forceUpdate) break;
        }
    }

    private void cascadeUnassignedValues(CascadingUpdateShadowVariableDescriptor<Solution_> cascadingUpdateShadowVariableDescriptor) {
        for (Object unassignedValue : this.unassignedValueWithEmptyInverseEntitySet) {
            cascadingUpdateShadowVariableDescriptor.update(this.scoreDirector, unassignedValue);
        }
    }

    public @Nullable String createShadowVariablesViolationMessage() {
        Object workingSolution = this.scoreDirector.getWorkingSolution();
        ShadowVariablesAssert snapshot = ShadowVariablesAssert.takeSnapshot(this.scoreDirector.getSolutionDescriptor(), workingSolution);
        this.forceTriggerAllVariableListeners(workingSolution);
        return snapshot.createShadowVariablesViolationMessage(3L);
    }

    public void forceTriggerAllVariableListeners(Solution_ workingSolution) {
        this.scoreDirector.getSolutionDescriptor().visitAllEntities(workingSolution, this::simulateGenuineVariableChange);
        this.triggerVariableListenersInNotificationQueues();
    }

    public void clearAllVariableListenerEvents() {
        this.notifiableRegistry.getAll().forEach(Notifiable::clearAllNotifications);
        this.notificationQueuesAreEmpty = true;
    }

    private void simulateGenuineVariableChange(Object entity) {
        EntityDescriptor<Solution_> entityDescriptor = this.scoreDirector.getSolutionDescriptor().findEntityDescriptorOrFail(entity.getClass());
        if (!entityDescriptor.isGenuine()) {
            return;
        }
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getGenuineVariableDescriptorList()) {
            if (variableDescriptor.isListVariable()) {
                ListVariableDescriptor descriptor = (ListVariableDescriptor)variableDescriptor;
                int size = descriptor.getValue(entity).size();
                this.beforeListVariableChanged(descriptor, entity, 0, size);
                this.afterListVariableChanged(descriptor, entity, 0, size);
                continue;
            }
            this.beforeVariableChanged(variableDescriptor, entity);
        }
    }

    public void assertNotificationQueuesAreEmpty() {
        if (!this.notificationQueuesAreEmpty) {
            throw new IllegalStateException("The notificationQueues might not be empty (%s) so any shadow variables might be stale so score calculation is unreliable.\nMaybe a %s.before*() method was called without calling %s.triggerVariableListeners(), before calling %s.calculateScore().".formatted(this.notificationQueuesAreEmpty, ScoreDirector.class.getSimpleName(), ScoreDirector.class.getSimpleName(), ScoreDirector.class.getSimpleName()));
        }
    }

    private record SupplyWithDemandCount(Supply supply, long demandCount) {
    }
}

