/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.declarative;

import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedStatus;
import ai.timefold.solver.core.impl.domain.variable.declarative.LoopedTracker;
import ai.timefold.solver.core.impl.domain.variable.declarative.TopologicalOrderGraph;
import ai.timefold.solver.core.impl.util.CollectionUtils;
import ai.timefold.solver.core.impl.util.MutableInt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;

public class DefaultTopologicalOrderGraph
implements TopologicalOrderGraph {
    private final int[] ord;
    private final Map<Integer, List<Integer>> componentMap;
    private final Set<Integer>[] forwardEdges;
    private final Set<Integer>[] backEdges;

    public DefaultTopologicalOrderGraph(int size) {
        this.ord = new int[size];
        this.componentMap = CollectionUtils.newLinkedHashMap(size);
        this.forwardEdges = new Set[size];
        this.backEdges = new Set[size];
        for (int i = 0; i < size; ++i) {
            this.forwardEdges[i] = new HashSet<Integer>();
            this.backEdges[i] = new HashSet<Integer>();
            this.ord[i] = i;
        }
    }

    @Override
    public void addEdge(int from, int to) {
        this.forwardEdges[from].add(to);
        this.backEdges[to].add(from);
    }

    @Override
    public void removeEdge(int from, int to) {
        this.forwardEdges[from].remove(to);
        this.backEdges[to].remove(from);
    }

    @Override
    public PrimitiveIterator.OfInt nodeForwardEdges(int from) {
        return this.componentMap.get(from).stream().flatMap(member -> this.forwardEdges[member].stream()).mapToInt(Integer::intValue).distinct().iterator();
    }

    @Override
    public boolean isLooped(LoopedTracker loopedTracker, int node) {
        return switch (loopedTracker.status(node)) {
            default -> throw new IncompatibleClassChangeError();
            case LoopedStatus.UNKNOWN -> {
                if (this.componentMap.get(node).size() > 1) {
                    loopedTracker.mark(node, LoopedStatus.LOOPED);
                    yield true;
                }
                for (Integer backEdge : this.backEdges[node]) {
                    if (!this.isLooped(loopedTracker, backEdge)) continue;
                    loopedTracker.mark(node, LoopedStatus.LOOPED);
                    yield true;
                }
                loopedTracker.mark(node, LoopedStatus.NOT_LOOPED);
                yield false;
            }
            case LoopedStatus.NOT_LOOPED -> false;
            case LoopedStatus.LOOPED -> true;
        };
    }

    @Override
    public int getTopologicalOrder(int node) {
        return this.ord[node];
    }

    @Override
    public void endBatchChange() {
        MutableInt index = new MutableInt(1);
        MutableInt stackIndex = new MutableInt(0);
        int size = this.forwardEdges.length;
        int[] stack = new int[size];
        int[] indexMap = new int[size];
        int[] lowMap = new int[size];
        boolean[] onStackSet = new boolean[size];
        ArrayList<BitSet> components = new ArrayList<BitSet>();
        this.componentMap.clear();
        for (int node = 0; node < size; ++node) {
            if (indexMap[node] != 0) continue;
            this.strongConnect(node, index, stackIndex, stack, indexMap, lowMap, onStackSet, components);
        }
        int ordIndex = 0;
        block1: for (int i = components.size() - 1; i >= 0; --i) {
            BitSet component = (BitSet)components.get(i);
            ArrayList<Integer> componentNodes = new ArrayList<Integer>(component.cardinality());
            int node = component.nextSetBit(0);
            while (node >= 0) {
                this.ord[node] = ordIndex++;
                componentNodes.add(node);
                this.componentMap.put(node, componentNodes);
                if (node == Integer.MAX_VALUE) continue block1;
                node = component.nextSetBit(node + 1);
            }
        }
    }

    private void strongConnect(int node, MutableInt index, MutableInt stackIndex, int[] stack, int[] indexMap, int[] lowMap, boolean[] onStackSet, List<BitSet> components) {
        indexMap[node] = index.intValue();
        lowMap[node] = index.intValue();
        index.increment();
        stack[stackIndex.intValue()] = node;
        onStackSet[node] = true;
        stackIndex.increment();
        for (Integer successor : this.forwardEdges[node]) {
            if (indexMap[successor] == 0) {
                this.strongConnect(successor, index, stackIndex, stack, indexMap, lowMap, onStackSet, components);
                lowMap[node] = Math.min(lowMap[node], lowMap[successor]);
                continue;
            }
            if (!onStackSet[successor]) continue;
            lowMap[node] = Math.min(lowMap[node], indexMap[successor]);
        }
        if (onStackSet[node] && lowMap[node] == indexMap[node]) {
            int current;
            BitSet out = new BitSet();
            do {
                current = stack[stackIndex.decrement()];
                onStackSet[current] = false;
                out.set(current);
            } while (node != current);
            components.add(out);
        }
    }
}

