/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.lookup;

import ai.timefold.solver.core.api.domain.lookup.LookUpStrategyType;
import ai.timefold.solver.core.api.domain.lookup.PlanningId;
import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.api.domain.solution.ProblemFactCollectionProperty;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.lookup.LookUpStrategy;
import ai.timefold.solver.core.impl.util.Pair;
import java.util.Map;

public final class PlanningIdLookUpStrategy
implements LookUpStrategy {
    private final MemberAccessor planningIdMemberAccessor;

    public PlanningIdLookUpStrategy(MemberAccessor planningIdMemberAccessor) {
        this.planningIdMemberAccessor = planningIdMemberAccessor;
    }

    @Override
    public void addWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Pair<Class<?>, Object> planningId = this.extractPlanningId(workingObject);
        Object oldAddedObject = idToWorkingObjectMap.put(planningId, workingObject);
        if (oldAddedObject != null) {
            throw new IllegalStateException("The workingObjects (" + String.valueOf(oldAddedObject) + ", " + String.valueOf(workingObject) + ") have the same planningId (" + String.valueOf(planningId) + "). Working objects must be unique.");
        }
    }

    @Override
    public void removeWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Pair<Class<?>, Object> planningId = this.extractPlanningId(workingObject);
        Object removedObject = idToWorkingObjectMap.remove(planningId);
        if (workingObject != removedObject) {
            throw new IllegalStateException("The workingObject (" + String.valueOf(workingObject) + ") differs from the removedObject (" + String.valueOf(removedObject) + ") for planningId (" + String.valueOf(planningId) + ").");
        }
    }

    @Override
    public <E> E lookUpWorkingObject(Map<Object, Object> idToWorkingObjectMap, E externalObject) {
        Pair<Class<?>, Object> planningId = this.extractPlanningId(externalObject);
        Object workingObject = idToWorkingObjectMap.get(planningId);
        if (workingObject == null) {
            throw new IllegalStateException("The externalObject (" + String.valueOf(externalObject) + ") with planningId (" + String.valueOf(planningId) + ") has no known workingObject (" + String.valueOf(workingObject) + ").\nMaybe the workingObject was never added because the planning solution doesn't have a @" + ProblemFactCollectionProperty.class.getSimpleName() + " annotation on a member with instances of the externalObject's class (" + String.valueOf(externalObject.getClass()) + ").");
        }
        return (E)workingObject;
    }

    @Override
    public <E> E lookUpWorkingObjectIfExists(Map<Object, Object> idToWorkingObjectMap, E externalObject) {
        Pair<Class<?>, Object> planningId = this.extractPlanningId(externalObject);
        return (E)idToWorkingObjectMap.get(planningId);
    }

    private Pair<Class<?>, Object> extractPlanningId(Object externalObject) {
        Object planningId = this.planningIdMemberAccessor.executeGetter(externalObject);
        if (planningId == null) {
            throw new IllegalArgumentException("The planningId (" + String.valueOf(planningId) + ") of the member (" + String.valueOf(this.planningIdMemberAccessor) + ") of the class (" + String.valueOf(externalObject.getClass()) + ") on externalObject (" + String.valueOf(externalObject) + ") must not be null.\nMaybe initialize the planningId of the class (" + externalObject.getClass().getSimpleName() + ") instance (" + String.valueOf(externalObject) + ") before solving.\nMaybe remove the @" + PlanningId.class.getSimpleName() + " annotation or change the @" + PlanningSolution.class.getSimpleName() + " annotation's " + LookUpStrategyType.class.getSimpleName() + ".");
        }
        return new Pair(externalObject.getClass(), planningId);
    }
}

