/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractStepScope;
import ai.timefold.solver.core.impl.solver.termination.SolverBridgePhaseTermination;
import ai.timefold.solver.core.impl.solver.termination.SolverTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.termination.UniversalTermination;
import org.jspecify.annotations.NullMarked;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
public interface PhaseTermination<Solution_>
extends Termination<Solution_> {
    default public boolean isApplicableTo(Class<? extends AbstractPhaseScope> phaseScopeClass) {
        return true;
    }

    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> var1);

    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> var1);

    public void phaseStarted(AbstractPhaseScope<Solution_> var1);

    public void stepStarted(AbstractStepScope<Solution_> var1);

    public void stepEnded(AbstractStepScope<Solution_> var1);

    public void phaseEnded(AbstractPhaseScope<Solution_> var1);

    public static <Solution_> PhaseTermination<Solution_> bridge(SolverTermination<Solution_> termination) {
        if (termination instanceof UniversalTermination) {
            UniversalTermination universalTermination = (UniversalTermination)termination;
            return universalTermination;
        }
        return new SolverBridgePhaseTermination<Solution_>(termination);
    }
}

