/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractUniversalTermination;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.NullMarked;

@NullMarked
final class BestScoreTermination<Solution_>
extends AbstractUniversalTermination<Solution_> {
    private final int levelsSize;
    private final Score<?> bestScoreLimit;
    private final double[] timeGradientWeightNumbers;

    public BestScoreTermination(ScoreDefinition<?> scoreDefinition, Score<?> bestScoreLimit, double[] timeGradientWeightNumbers) {
        this.levelsSize = scoreDefinition.getLevelsSize();
        this.bestScoreLimit = Objects.requireNonNull(bestScoreLimit, "The bestScoreLimit cannot be null.");
        this.timeGradientWeightNumbers = timeGradientWeightNumbers;
        if (timeGradientWeightNumbers.length != this.levelsSize - 1) {
            throw new IllegalStateException("The timeGradientWeightNumbers (%s)'s length (%d) is not 1 less than the levelsSize (%d).".formatted(Arrays.toString(timeGradientWeightNumbers), timeGradientWeightNumbers.length, scoreDefinition.getLevelsSize()));
        }
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        return this.isTerminated(solverScope.isBestSolutionInitialized(), solverScope.getBestScore());
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        return this.isTerminated(phaseScope.isBestSolutionInitialized(), (Score<?>)phaseScope.getBestScore());
    }

    private boolean isTerminated(boolean bestSolutionInitialized, Score<?> bestScore) {
        return bestSolutionInitialized && bestScore.compareTo(this.bestScoreLimit) >= 0;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        Score startingInitializedScore = solverScope.getStartingInitializedScore();
        Score bestScore = solverScope.getBestScore();
        return this.calculateTimeGradient(startingInitializedScore, this.bestScoreLimit, bestScore);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        Object startingInitializedScore = phaseScope.getStartingScore();
        Object bestScore = phaseScope.getBestScore();
        return this.calculateTimeGradient(startingInitializedScore, (Score)this.bestScoreLimit, bestScore);
    }

    <Score_ extends Score<Score_>> double calculateTimeGradient(Score_ startScore, Score_ endScore, Score_ score) {
        Score_ totalDiff = endScore.subtract(startScore);
        Number[] totalDiffNumbers = totalDiff.toLevelNumbers();
        Score_ scoreDiff = score.subtract(startScore);
        Number[] scoreDiffNumbers = scoreDiff.toLevelNumbers();
        if (scoreDiffNumbers.length != totalDiffNumbers.length) {
            throw new IllegalStateException("The startScore (" + String.valueOf(startScore) + "), endScore (" + String.valueOf(endScore) + ") and score (" + String.valueOf(score) + ") don't have the same levelsSize.");
        }
        return BestScoreTermination.calculateTimeGradient(totalDiffNumbers, scoreDiffNumbers, this.timeGradientWeightNumbers, this.levelsSize);
    }

    static double calculateTimeGradient(Number[] totalDiffNumbers, Number[] scoreDiffNumbers, double[] timeGradientWeightNumbers, int levelDepth) {
        double timeGradient = 0.0;
        double remainingTimeGradient = 1.0;
        for (int i = 0; i < levelDepth; ++i) {
            double levelTimeGradientWeight;
            if (i != levelDepth - 1) {
                levelTimeGradientWeight = remainingTimeGradient * timeGradientWeightNumbers[i];
                remainingTimeGradient -= levelTimeGradientWeight;
            } else {
                levelTimeGradientWeight = remainingTimeGradient;
                remainingTimeGradient = 0.0;
            }
            double totalDiffLevel = totalDiffNumbers[i].doubleValue();
            double scoreDiffLevel = scoreDiffNumbers[i].doubleValue();
            if (scoreDiffLevel == totalDiffLevel) {
                timeGradient += levelTimeGradientWeight;
                continue;
            }
            if (scoreDiffLevel > totalDiffLevel) {
                timeGradient += levelTimeGradientWeight + remainingTimeGradient;
                break;
            }
            if (scoreDiffLevel == 0.0) continue;
            if (scoreDiffLevel < 0.0) break;
            double levelTimeGradient = scoreDiffLevel / totalDiffLevel;
            timeGradient += levelTimeGradient * levelTimeGradientWeight;
        }
        if (timeGradient > 1.0) {
            timeGradient = 1.0;
        }
        return timeGradient;
    }

    public String toString() {
        return "BestScore(" + String.valueOf(this.bestScoreLimit) + ")";
    }
}

