/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.common.inliner;

import ai.timefold.solver.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraint;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import ai.timefold.solver.core.impl.score.stream.common.inliner.HardMediumSoftScoreContext;
import ai.timefold.solver.core.impl.score.stream.common.inliner.WeightedScoreImpacter;
import java.util.Map;

final class HardMediumSoftScoreInliner
extends AbstractScoreInliner<HardMediumSoftScore> {
    int hardScore;
    int mediumScore;
    int softScore;

    HardMediumSoftScoreInliner(Map<Constraint, HardMediumSoftScore> constraintWeightMap, ConstraintMatchPolicy constraintMatchPolicy) {
        super(constraintWeightMap, constraintMatchPolicy);
    }

    @Override
    public WeightedScoreImpacter<HardMediumSoftScore, ?> buildWeightedScoreImpacter(AbstractConstraint<?, ?, ?> constraint) {
        HardMediumSoftScore constraintWeight = (HardMediumSoftScore)this.constraintWeightMap.get(constraint);
        int hardConstraintWeight = constraintWeight.hardScore();
        int mediumConstraintWeight = constraintWeight.mediumScore();
        int softConstraintWeight = constraintWeight.softScore();
        HardMediumSoftScoreContext context = new HardMediumSoftScoreContext(this, constraint, constraintWeight);
        if (mediumConstraintWeight == 0 && softConstraintWeight == 0) {
            return WeightedScoreImpacter.of(context, HardMediumSoftScoreContext::changeHardScoreBy);
        }
        if (hardConstraintWeight == 0 && softConstraintWeight == 0) {
            return WeightedScoreImpacter.of(context, HardMediumSoftScoreContext::changeMediumScoreBy);
        }
        if (hardConstraintWeight == 0 && mediumConstraintWeight == 0) {
            return WeightedScoreImpacter.of(context, HardMediumSoftScoreContext::changeSoftScoreBy);
        }
        return WeightedScoreImpacter.of(context, HardMediumSoftScoreContext::changeScoreBy);
    }

    @Override
    public HardMediumSoftScore extractScore(int initScore) {
        return HardMediumSoftScore.ofUninitialized(initScore, this.hardScore, this.mediumScore, this.softScore);
    }

    public String toString() {
        return HardMediumSoftScore.class.getSimpleName() + " inliner";
    }
}

