/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.stream.collector;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.stream.Stream;

public final class ToMapPerKeyCounter<Value_> {
    private final Map<Value_, Long> counts = new LinkedHashMap<Value_, Long>(0);

    public long add(Value_ value) {
        return this.counts.compute(value, (k, currentCount) -> {
            if (currentCount == null) {
                return 1L;
            }
            return currentCount + 1L;
        });
    }

    public long remove(Value_ value) {
        Long newCount = this.counts.compute(value, (k, currentCount) -> {
            if (currentCount > 1L) {
                return currentCount - 1L;
            }
            return null;
        });
        return newCount == null ? 0L : newCount;
    }

    public Value_ merge(BinaryOperator<Value_> mergeFunction) {
        return (Value_)this.counts.entrySet().stream().map(e -> Stream.generate(e::getKey).limit((Long)e.getValue()).reduce(mergeFunction).orElseThrow(() -> new IllegalStateException("Impossible state: Should have had at least one value."))).reduce(mergeFunction).orElseThrow(() -> new IllegalStateException("Impossible state: Should have had at least one value."));
    }

    public boolean isEmpty() {
        return this.counts.isEmpty();
    }
}

