/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director.stream;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintMetaModel;
import ai.timefold.solver.core.api.score.stream.ConstraintProvider;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.enterprise.TimefoldSolverEnterpriseService;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.constraint.ConstraintMatchPolicy;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirector;
import ai.timefold.solver.core.impl.score.director.stream.BavetConstraintStreamScoreDirector;
import ai.timefold.solver.core.impl.score.director.stream.DefaultConstraintMetaModel;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintFactory;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintSession;
import ai.timefold.solver.core.impl.score.stream.bavet.BavetConstraintSessionFactory;
import ai.timefold.solver.core.impl.score.stream.common.AbstractConstraintStreamScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.stream.common.inliner.AbstractScoreInliner;
import java.util.Arrays;
import java.util.function.Consumer;

public final class BavetConstraintStreamScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_, BavetConstraintStreamScoreDirectorFactory<Solution_, Score_>> {
    private final BavetConstraintSessionFactory<Solution_, Score_> constraintSessionFactory;
    private final ConstraintMetaModel constraintMetaModel;

    public static <Solution_, Score_ extends Score<Score_>> BavetConstraintStreamScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ScoreDirectorFactoryConfig config, EnvironmentMode environmentMode) {
        Class<? extends ConstraintProvider> providedConstraintProviderClass = config.getConstraintProviderClass();
        if (providedConstraintProviderClass == null || !ConstraintProvider.class.isAssignableFrom(providedConstraintProviderClass)) {
            throw new IllegalArgumentException("The constraintProviderClass (%s) does not implement %s.".formatted(providedConstraintProviderClass, ConstraintProvider.class.getSimpleName()));
        }
        Class<ConstraintProvider> constraintProviderClass = BavetConstraintStreamScoreDirectorFactory.getConstraintProviderClass(config, providedConstraintProviderClass);
        ConstraintProvider constraintProvider = ConfigUtils.newInstance(config, "constraintProviderClass", constraintProviderClass);
        ConfigUtils.applyCustomProperties(constraintProvider, "constraintProviderClass", config.getConstraintProviderCustomProperties(), "constraintProviderCustomProperties");
        return new BavetConstraintStreamScoreDirectorFactory<Solution_, Score_>(solutionDescriptor, constraintProvider, environmentMode);
    }

    private static Class<? extends ConstraintProvider> getConstraintProviderClass(ScoreDirectorFactoryConfig config, Class<? extends ConstraintProvider> providedConstraintProviderClass) {
        if (Boolean.TRUE.equals(config.getConstraintStreamAutomaticNodeSharing())) {
            TimefoldSolverEnterpriseService enterpriseService = TimefoldSolverEnterpriseService.loadOrFail(TimefoldSolverEnterpriseService.Feature.AUTOMATIC_NODE_SHARING);
            return enterpriseService.buildLambdaSharedConstraintProvider(config.getConstraintProviderClass());
        }
        return providedConstraintProviderClass;
    }

    public BavetConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, EnvironmentMode environmentMode) {
        super(solutionDescriptor);
        BavetConstraintFactory<Solution_> constraintFactory = new BavetConstraintFactory<Solution_>(solutionDescriptor, environmentMode);
        this.constraintMetaModel = DefaultConstraintMetaModel.of(constraintFactory.buildConstraints(constraintProvider));
        this.constraintSessionFactory = new BavetConstraintSessionFactory(solutionDescriptor, this.constraintMetaModel);
    }

    public BavetConstraintSession<Score_> newSession(Solution_ workingSolution, ConstraintMatchPolicy constraintMatchPolicy, boolean scoreDirectorDerived) {
        return this.newSession(workingSolution, constraintMatchPolicy, scoreDirectorDerived, null);
    }

    public BavetConstraintSession<Score_> newSession(Solution_ workingSolution, ConstraintMatchPolicy constraintMatchPolicy, boolean scoreDirectorDerived, Consumer<String> nodeNetworkVisualizationConsumer) {
        return this.constraintSessionFactory.buildSession(workingSolution, constraintMatchPolicy, scoreDirectorDerived, nodeNetworkVisualizationConsumer);
    }

    @Override
    public AbstractScoreInliner<Score_> fireAndForget(Object ... facts) {
        BavetConstraintSession<Score_> session = this.newSession(null, ConstraintMatchPolicy.ENABLED, true);
        Arrays.stream(facts).forEach(session::insert);
        session.calculateScore(0);
        return session.getScoreInliner();
    }

    @Override
    public ConstraintMetaModel getConstraintMetaModel() {
        return this.constraintMetaModel;
    }

    public BavetConstraintStreamScoreDirector.Builder<Solution_, Score_> createScoreDirectorBuilder() {
        return new BavetConstraintStreamScoreDirector.Builder(this);
    }

    @Override
    public AbstractScoreDirector<Solution_, Score_, ?> buildScoreDirector() {
        return ((BavetConstraintStreamScoreDirector.Builder)this.createScoreDirectorBuilder()).build();
    }
}

