/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase;

import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.phase.PossiblyInitializingPhase;
import ai.timefold.solver.core.impl.phase.custom.CustomPhase;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public abstract class AbstractPossiblyInitializingPhase<Solution_>
extends AbstractPhase<Solution_>
implements PossiblyInitializingPhase<Solution_> {
    private final boolean lastInitializingPhase;

    protected AbstractPossiblyInitializingPhase(AbstractPossiblyInitializingPhaseBuilder<Solution_> builder) {
        super(builder);
        this.lastInitializingPhase = builder.isLastInitializingPhase();
    }

    @Override
    public final boolean isLastInitializingPhase() {
        return this.lastInitializingPhase;
    }

    protected static PossiblyInitializingPhase.TerminationStatus translateEarlyTermination(AbstractPhaseScope<?> phaseScope, @Nullable PossiblyInitializingPhase.TerminationStatus earlyTerminationStatus, boolean hasMoreSteps) {
        if (earlyTerminationStatus == null || !hasMoreSteps) {
            return PossiblyInitializingPhase.TerminationStatus.regular(phaseScope.getNextStepIndex());
        }
        return earlyTerminationStatus;
    }

    protected void ensureCorrectTermination(AbstractPhaseScope<Solution_> phaseScope, Logger logger) {
        PossiblyInitializingPhase.TerminationStatus terminationStatus = this.getTerminationStatus();
        if (!terminationStatus.terminated()) {
            throw new IllegalStateException("Impossible state: construction heuristic phase (%d) ended, but not terminated.".formatted(phaseScope.getPhaseIndex()));
        }
        if (terminationStatus.early()) {
            String advice = this instanceof CustomPhase ? "If the phase was used to initialize the solution, the solution may not be fully initialized." : "The solution may not be fully initialized.";
            logger.warn("{} terminated early with step count ({}).\n{}", new Object[]{this.getClass().getSimpleName(), terminationStatus.stepCount(), advice});
        }
    }

    public static abstract class AbstractPossiblyInitializingPhaseBuilder<Solution_>
    extends AbstractPhase.AbstractPhaseBuilder<Solution_> {
        private final boolean lastInitializingPhase;

        protected AbstractPossiblyInitializingPhaseBuilder(int phaseIndex, boolean lastInitializingPhase, String phaseName, PhaseTermination<Solution_> phaseTermination) {
            super(phaseIndex, phaseName, phaseTermination);
            this.lastInitializingPhase = lastInitializingPhase;
        }

        public boolean isLastInitializingPhase() {
            return this.lastInitializingPhase;
        }
    }
}

