/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.move.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningListVariableMetaModel;
import ai.timefold.solver.core.impl.domain.solution.descriptor.DefaultPlanningVariableMetaModel;
import ai.timefold.solver.core.impl.domain.variable.descriptor.BasicVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.LegacyMoveAdapter;
import ai.timefold.solver.core.impl.move.InnerMutableSolutionView;
import ai.timefold.solver.core.impl.move.director.EphemeralMoveDirector;
import ai.timefold.solver.core.impl.move.director.VariableChangeRecordingScoreDirector;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.score.director.VariableDescriptorAwareScoreDirector;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementLocation;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningListVariableMetaModel;
import ai.timefold.solver.core.preview.api.domain.metamodel.PlanningVariableMetaModel;
import ai.timefold.solver.core.preview.api.move.Move;
import ai.timefold.solver.core.preview.api.move.Rebaser;
import java.util.Objects;
import java.util.function.BiFunction;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@NullMarked
public class MoveDirector<Solution_, Score_ extends Score<Score_>>
implements InnerMutableSolutionView<Solution_>,
Rebaser {
    protected final VariableDescriptorAwareScoreDirector<Solution_> externalScoreDirector;
    private final InnerScoreDirector<Solution_, Score_> backingScoreDirector;

    public MoveDirector(InnerScoreDirector<Solution_, Score_> scoreDirector) {
        this.backingScoreDirector = Objects.requireNonNull(scoreDirector);
        this.externalScoreDirector = EphemeralMoveDirector.class.isAssignableFrom(this.getClass()) ? new VariableChangeRecordingScoreDirector(scoreDirector, false) : scoreDirector;
    }

    @Override
    public final <Entity_, Value_> void assignValue(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ planningValue, Entity_ destinationEntity, int destinationIndex) {
        VariableDescriptor variableDescriptor = ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
        this.externalScoreDirector.beforeListVariableElementAssigned((ListVariableDescriptor<Solution_>)variableDescriptor, planningValue);
        this.externalScoreDirector.beforeListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, destinationEntity, destinationIndex, destinationIndex);
        ((ListVariableDescriptor)variableDescriptor).addElement(destinationEntity, destinationIndex, planningValue);
        this.externalScoreDirector.afterListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, destinationEntity, destinationIndex, destinationIndex + 1);
        this.externalScoreDirector.afterListVariableElementAssigned((ListVariableDescriptor<Solution_>)variableDescriptor, planningValue);
    }

    @Override
    public final <Entity_, Value_> void unassignValue(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ movedValue, Entity_ sourceEntity, int sourceIndex) {
        VariableDescriptor variableDescriptor = ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
        this.externalScoreDirector.beforeListVariableElementUnassigned((ListVariableDescriptor<Solution_>)variableDescriptor, movedValue);
        this.externalScoreDirector.beforeListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, sourceEntity, sourceIndex, sourceIndex + 1);
        ((ListVariableDescriptor)variableDescriptor).getValue(sourceEntity).remove(sourceIndex);
        this.externalScoreDirector.afterListVariableChanged((ListVariableDescriptor<Solution_>)variableDescriptor, sourceEntity, sourceIndex, sourceIndex);
        this.externalScoreDirector.afterListVariableElementUnassigned((ListVariableDescriptor<Solution_>)variableDescriptor, movedValue);
    }

    @Override
    public final <Entity_, Value_> void changeVariable(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, @Nullable Value_ newValue) {
        BasicVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        this.externalScoreDirector.beforeVariableChanged(variableDescriptor, entity);
        variableDescriptor.setValue(entity, newValue);
        this.externalScoreDirector.afterVariableChanged(variableDescriptor, entity);
    }

    @Override
    public final <Entity_, Value_> @Nullable Value_ moveValueBetweenLists(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ sourceEntity, int sourceIndex, Entity_ destinationEntity, int destinationIndex) {
        if (sourceEntity == destinationEntity) {
            return this.moveValueInList(variableMetaModel, sourceEntity, sourceIndex, destinationIndex);
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, sourceEntity, sourceIndex, sourceIndex + 1);
        Object element = variableDescriptor.removeElement(sourceEntity, sourceIndex);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, sourceEntity, sourceIndex, sourceIndex);
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, destinationEntity, destinationIndex, destinationIndex);
        variableDescriptor.addElement(destinationEntity, destinationIndex, element);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, destinationEntity, destinationIndex, destinationIndex + 1);
        return (Value_)element;
    }

    @Override
    public final <Entity_, Value_> @Nullable Value_ moveValueInList(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, int sourceIndex, int destinationIndex) {
        if (sourceIndex == destinationIndex) {
            return null;
        }
        if (sourceIndex > destinationIndex) {
            return this.moveValueInList(variableMetaModel, entity, destinationIndex, sourceIndex);
        }
        ListVariableDescriptor<Solution_> variableDescriptor = MoveDirector.extractVariableDescriptor(variableMetaModel);
        int toIndex = destinationIndex + 1;
        this.externalScoreDirector.beforeListVariableChanged(variableDescriptor, entity, sourceIndex, toIndex);
        Object variable = variableDescriptor.getValue(entity);
        Object value = variable.remove(sourceIndex);
        variable.add(destinationIndex, value);
        this.externalScoreDirector.afterListVariableChanged(variableDescriptor, entity, sourceIndex, toIndex);
        return (Value_)value;
    }

    public final void execute(Move<Solution_> move) {
        move.execute(this);
        this.externalScoreDirector.triggerVariableListeners();
    }

    public final void execute(ai.timefold.solver.core.impl.heuristic.move.Move<Solution_> move) {
        this.execute(new LegacyMoveAdapter<Solution_>(move));
    }

    public final Score_ executeTemporary(Move<Solution_> move) {
        EphemeralMoveDirector<Solution_, Score_> ephemeralMoveDirector = this.ephemeral();
        ephemeralMoveDirector.execute(move);
        Score_ score = this.backingScoreDirector.calculateScore();
        ephemeralMoveDirector.close();
        return score;
    }

    public <Result_> Result_ executeTemporary(Move<Solution_> move, TemporaryMovePostprocessor<Solution_, Score_, Result_> postprocessor) {
        EphemeralMoveDirector<Solution_, Score_> ephemeralMoveDirector = this.ephemeral();
        ephemeralMoveDirector.execute(move);
        Score_ score = this.backingScoreDirector.calculateScore();
        Object result = postprocessor.apply(score, ephemeralMoveDirector.createUndoMove());
        ephemeralMoveDirector.close();
        return (Result_)result;
    }

    public final <Result_> Result_ executeTemporary(ai.timefold.solver.core.impl.heuristic.move.Move<Solution_> move, TemporaryMovePostprocessor<Solution_, Score_, Result_> postprocessor) {
        return this.executeTemporary(new LegacyMoveAdapter<Solution_>(move), postprocessor);
    }

    @Override
    public final <Entity_, Value_> Value_ getValue(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity) {
        return MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity);
    }

    @Override
    public final <Entity_, Value_> Value_ getValueAtIndex(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Entity_ entity, int index) {
        return (Value_)MoveDirector.extractVariableDescriptor(variableMetaModel).getValue(entity).get(index);
    }

    @Override
    public <Entity_, Value_> ElementLocation getPositionOf(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ value) {
        return MoveDirector.getPositionOf(this.backingScoreDirector, variableMetaModel, value);
    }

    protected static <Solution_, Entity_, Value_> ElementLocation getPositionOf(InnerScoreDirector<Solution_, ?> scoreDirector, PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel, Value_ value) {
        return scoreDirector.getListVariableStateSupply(MoveDirector.extractVariableDescriptor(variableMetaModel)).getLocationInList(value);
    }

    @Override
    public final <T> @Nullable T rebase(@Nullable T problemFactOrPlanningEntity) {
        return this.externalScoreDirector.lookUpWorkingObject(problemFactOrPlanningEntity);
    }

    private static <Solution_, Entity_, Value_> BasicVariableDescriptor<Solution_> extractVariableDescriptor(PlanningVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return ((DefaultPlanningVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    private static <Solution_, Entity_, Value_> ListVariableDescriptor<Solution_> extractVariableDescriptor(PlanningListVariableMetaModel<Solution_, Entity_, Value_> variableMetaModel) {
        return ((DefaultPlanningListVariableMetaModel)variableMetaModel).variableDescriptor();
    }

    final EphemeralMoveDirector<Solution_, Score_> ephemeral() {
        return new EphemeralMoveDirector<Solution_, Score_>(this.backingScoreDirector);
    }

    @Override
    public final VariableDescriptorAwareScoreDirector<Solution_> getScoreDirector() {
        return this.externalScoreDirector;
    }

    @FunctionalInterface
    public static interface TemporaryMovePostprocessor<Solution_, Score_ extends Score<Score_>, Result_>
    extends BiFunction<Score_, Move<Solution_>, Result_> {
    }
}

