/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.SubListSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.SubListSwapMoveSelectorConfig;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.RandomSubListSwapMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.SubListConfigUtil;
import java.util.Objects;

public class SubListSwapMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, SubListSwapMoveSelectorConfig> {
    public SubListSwapMoveSelectorFactory(SubListSwapMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (!randomSelection) {
            throw new IllegalArgumentException("The subListSwapMoveSelector (" + String.valueOf(this.config) + ") only supports random selection order.");
        }
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(new EntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        SubListSelectorConfig subListSelectorConfig = Objects.requireNonNullElseGet(((SubListSwapMoveSelectorConfig)this.config).getSubListSelectorConfig(), SubListSelectorConfig::new);
        SubListSelectorConfig secondarySubListSelectorConfig = Objects.requireNonNullElse(((SubListSwapMoveSelectorConfig)this.config).getSecondarySubListSelectorConfig(), subListSelectorConfig);
        SubListConfigUtil.transferDeprecatedMinimumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMinimumSubListSize, "subListSelector", subListSelectorConfig);
        SubListConfigUtil.transferDeprecatedMaximumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMaximumSubListSize, "subListSelector", subListSelectorConfig);
        if (subListSelectorConfig != secondarySubListSelectorConfig) {
            SubListConfigUtil.transferDeprecatedMinimumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMinimumSubListSize, "secondarySubListSelector", secondarySubListSelectorConfig);
            SubListConfigUtil.transferDeprecatedMaximumSubListSize((SubListSwapMoveSelectorConfig)this.config, SubListSwapMoveSelectorConfig::getMaximumSubListSize, "secondarySubListSelector", secondarySubListSelectorConfig);
        }
        SubListSelector leftSubListSelector = SubListSelectorFactory.create(subListSelectorConfig).buildSubListSelector(configPolicy, entitySelector, minimumCacheType, selectionOrder);
        SubListSelector rightSubListSelector = SubListSelectorFactory.create(secondarySubListSelectorConfig).buildSubListSelector(configPolicy, entitySelector, minimumCacheType, selectionOrder);
        boolean selectReversingMoveToo = Objects.requireNonNullElse(((SubListSwapMoveSelectorConfig)this.config).getSelectReversingMoveToo(), true);
        return new RandomSubListSwapMoveSelector(leftSubListSelector, rightSubListSelector, selectReversingMoveToo);
    }
}

