/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.ListVariableStateSupply;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.list.DestinationSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.OriginalListChangeIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.RandomListChangeIterator;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.FilteringValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.preview.api.domain.metamodel.ElementLocation;
import ai.timefold.solver.core.preview.api.domain.metamodel.LocationInList;
import ai.timefold.solver.core.preview.api.domain.metamodel.UnassignedLocation;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Supplier;

public class ListChangeMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final EntityIndependentValueSelector<Solution_> sourceValueSelector;
    private final DestinationSelector<Solution_> destinationSelector;
    private final boolean randomSelection;
    private ListVariableStateSupply<Solution_> listVariableStateSupply;

    public ListChangeMoveSelector(EntityIndependentValueSelector<Solution_> sourceValueSelector, DestinationSelector<Solution_> destinationSelector, boolean randomSelection) {
        this.sourceValueSelector = ListChangeMoveSelector.filterPinnedListPlanningVariableValuesWithIndex(sourceValueSelector, this::getListVariableStateSupply);
        this.destinationSelector = destinationSelector;
        this.randomSelection = randomSelection;
        this.phaseLifecycleSupport.addEventListener(this.sourceValueSelector);
        this.phaseLifecycleSupport.addEventListener(this.destinationSelector);
    }

    private ListVariableStateSupply<Solution_> getListVariableStateSupply() {
        return Objects.requireNonNull(this.listVariableStateSupply, "Impossible state: The listVariableStateSupply is not initialized yet.");
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)this.sourceValueSelector.getVariableDescriptor();
        SupplyManager supplyManager = solverScope.getScoreDirector().getSupplyManager();
        this.listVariableStateSupply = (ListVariableStateSupply)supplyManager.demand(listVariableDescriptor.getStateDemand());
    }

    public static <Solution_> EntityIndependentValueSelector<Solution_> filterPinnedListPlanningVariableValuesWithIndex(EntityIndependentValueSelector<Solution_> sourceValueSelector, Supplier<ListVariableStateSupply<Solution_>> listVariableStateSupplier) {
        ListVariableDescriptor listVariableDescriptor = (ListVariableDescriptor)sourceValueSelector.getVariableDescriptor();
        boolean supportsPinning = listVariableDescriptor.supportsPinning();
        if (!supportsPinning) {
            return sourceValueSelector;
        }
        return (EntityIndependentValueSelector)FilteringValueSelector.of(sourceValueSelector, (scoreDirector, selection) -> {
            ListVariableStateSupply listVariableStateSupply = (ListVariableStateSupply)listVariableStateSupplier.get();
            ElementLocation elementLocation = listVariableStateSupply.getLocationInList(selection);
            if (elementLocation instanceof UnassignedLocation) {
                return true;
            }
            LocationInList elementDestination = elementLocation.ensureAssigned();
            Object entity = elementDestination.entity();
            return !listVariableDescriptor.isElementPinned(scoreDirector.getWorkingSolution(), entity, elementDestination.index());
        });
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.listVariableStateSupply = null;
    }

    @Override
    public long getSize() {
        return this.sourceValueSelector.getSize() * this.destinationSelector.getSize();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (this.randomSelection) {
            return new RandomListChangeIterator<Solution_>(this.listVariableStateSupply, this.sourceValueSelector, this.destinationSelector);
        }
        return new OriginalListChangeIterator<Solution_>(this.listVariableStateSupply, this.sourceValueSelector, this.destinationSelector);
    }

    @Override
    public boolean isCountable() {
        return this.sourceValueSelector.isCountable() && this.destinationSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection || this.sourceValueSelector.isNeverEnding() || this.destinationSelector.isNeverEnding();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + String.valueOf(this.sourceValueSelector) + ", " + String.valueOf(this.destinationSelector) + ")";
    }
}

