/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.RuinRecreateConstructionHeuristicPhaseBuilder;
import ai.timefold.solver.core.impl.move.director.VariableChangeRecordingScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class RuinRecreateMove<Solution_>
extends AbstractMove<Solution_> {
    private final GenuineVariableDescriptor<Solution_> genuineVariableDescriptor;
    private final RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder;
    private final SolverScope<Solution_> solverScope;
    private final List<Object> ruinedEntityList;
    private final Set<Object> affectedValueSet;
    private Object[] recordedNewValues;

    public RuinRecreateMove(GenuineVariableDescriptor<Solution_> genuineVariableDescriptor, RuinRecreateConstructionHeuristicPhaseBuilder<Solution_> constructionHeuristicPhaseBuilder, SolverScope<Solution_> solverScope, List<Object> ruinedEntityList, Set<Object> affectedValueSet) {
        this.genuineVariableDescriptor = genuineVariableDescriptor;
        this.ruinedEntityList = ruinedEntityList;
        this.affectedValueSet = affectedValueSet;
        this.constructionHeuristicPhaseBuilder = constructionHeuristicPhaseBuilder;
        this.solverScope = solverScope;
        this.recordedNewValues = null;
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        this.recordedNewValues = new Object[this.ruinedEntityList.size()];
        VariableChangeRecordingScoreDirector recordingScoreDirector = (VariableChangeRecordingScoreDirector)scoreDirector;
        for (Object ruinedEntity : this.ruinedEntityList) {
            recordingScoreDirector.beforeVariableChanged(this.genuineVariableDescriptor, ruinedEntity);
            this.genuineVariableDescriptor.setValue(ruinedEntity, null);
            recordingScoreDirector.afterVariableChanged(this.genuineVariableDescriptor, ruinedEntity);
        }
        recordingScoreDirector.triggerVariableListeners();
        RuinRecreateConstructionHeuristicPhase constructionHeuristicPhase = (RuinRecreateConstructionHeuristicPhase)this.constructionHeuristicPhaseBuilder.ensureThreadSafe(recordingScoreDirector.getBacking()).withElementsToRecreate(this.ruinedEntityList).build();
        SolverScope nestedSolverScope = new SolverScope();
        nestedSolverScope.setSolver(this.solverScope.getSolver());
        nestedSolverScope.setScoreDirector(recordingScoreDirector.getBacking());
        constructionHeuristicPhase.solvingStarted(nestedSolverScope);
        constructionHeuristicPhase.solve(nestedSolverScope);
        constructionHeuristicPhase.solvingEnded(nestedSolverScope);
        scoreDirector.triggerVariableListeners();
        for (int i = 0; i < this.ruinedEntityList.size(); ++i) {
            this.recordedNewValues[i] = this.genuineVariableDescriptor.getValue(this.ruinedEntityList.get(i));
        }
    }

    @Override
    public Collection<?> getPlanningEntities() {
        return this.ruinedEntityList;
    }

    @Override
    public Collection<?> getPlanningValues() {
        return this.affectedValueSet;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        return true;
    }

    @Override
    public Move<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        List<Object> rebasedRuinedEntityList = RuinRecreateMove.rebaseList(this.ruinedEntityList, destinationScoreDirector);
        Set<Object> rebasedAffectedValueSet = RuinRecreateMove.rebaseSet(this.affectedValueSet, destinationScoreDirector);
        return new RuinRecreateMove<Solution_>(this.genuineVariableDescriptor, this.constructionHeuristicPhaseBuilder, this.solverScope, rebasedRuinedEntityList, rebasedAffectedValueSet);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RuinRecreateMove)) {
            return false;
        }
        RuinRecreateMove that = (RuinRecreateMove)o;
        return Objects.equals(this.genuineVariableDescriptor, that.genuineVariableDescriptor) && Objects.equals(this.ruinedEntityList, that.ruinedEntityList) && Objects.equals(this.affectedValueSet, that.affectedValueSet);
    }

    public int hashCode() {
        return Objects.hash(this.genuineVariableDescriptor, this.ruinedEntityList, this.affectedValueSet);
    }

    public String toString() {
        return "RuinMove{entities=" + String.valueOf(this.ruinedEntityList) + ", newValues=" + (this.recordedNewValues != null ? Arrays.toString(this.recordedNewValues) : "?") + "}";
    }
}

