/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.AbstractCachingEntitySelector;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Objects;

public final class CachingEntitySelector<Solution_>
extends AbstractCachingEntitySelector<Solution_> {
    private final boolean randomSelection;

    public CachingEntitySelector(EntitySelector<Solution_> childEntitySelector, SelectionCacheType cacheType, boolean randomSelection) {
        super(childEntitySelector, cacheType);
        this.randomSelection = randomSelection;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return this.cachedEntityList.iterator();
        }
        return new CachedListRandomIterator<Object>(this.cachedEntityList, this.workingRandom);
    }

    @Override
    public ListIterator<Object> listIterator() {
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator();
        }
        throw new IllegalStateException("The selector (" + String.valueOf(this) + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        if (!this.randomSelection) {
            return this.cachedEntityList.listIterator(index);
        }
        throw new IllegalStateException("The selector (" + String.valueOf(this) + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CachingEntitySelector that = (CachingEntitySelector)o;
        return this.randomSelection == that.randomSelection;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.randomSelection);
    }

    public String toString() {
        return "Caching(" + String.valueOf(this.childEntitySelector) + ")";
    }
}

