/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic;

import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.impl.constructionheuristic.ConstructionHeuristicPhase;
import ai.timefold.solver.core.impl.constructionheuristic.decider.ConstructionHeuristicDecider;
import ai.timefold.solver.core.impl.constructionheuristic.placer.EntityPlacer;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicPhaseScope;
import ai.timefold.solver.core.impl.constructionheuristic.scope.ConstructionHeuristicStepScope;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.move.PlacerBasedMoveRepository;
import ai.timefold.solver.core.impl.phase.AbstractPossiblyInitializingPhase;
import ai.timefold.solver.core.impl.phase.PossiblyInitializingPhase;
import ai.timefold.solver.core.impl.solver.AbstractSolver;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.PhaseTermination;
import ai.timefold.solver.core.preview.api.move.Move;
import org.jspecify.annotations.NullMarked;
import org.slf4j.event.Level;

@NullMarked
public class DefaultConstructionHeuristicPhase<Solution_>
extends AbstractPossiblyInitializingPhase<Solution_>
implements ConstructionHeuristicPhase<Solution_> {
    protected final ConstructionHeuristicDecider<Solution_> decider;
    protected final PlacerBasedMoveRepository<Solution_> moveRepository;
    private PossiblyInitializingPhase.TerminationStatus terminationStatus = PossiblyInitializingPhase.TerminationStatus.NOT_TERMINATED;

    protected DefaultConstructionHeuristicPhase(DefaultConstructionHeuristicPhaseBuilder<Solution_> builder) {
        super(builder);
        this.decider = builder.decider;
        this.moveRepository = new PlacerBasedMoveRepository<Solution_>(builder.getEntityPlacer());
    }

    public EntityPlacer<Solution_> getEntityPlacer() {
        return this.moveRepository.getPlacer();
    }

    @Override
    public PossiblyInitializingPhase.TerminationStatus getTerminationStatus() {
        return this.terminationStatus;
    }

    @Override
    public String getPhaseTypeString() {
        return "Construction Heuristics";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        ConstructionHeuristicPhaseScope<Solution_> phaseScope = this.buildPhaseScope(solverScope, this.phaseIndex);
        this.phaseStarted(phaseScope);
        SolutionDescriptor<Solution_> solutionDescriptor = solverScope.getSolutionDescriptor();
        ListVariableDescriptor listVariableDescriptor = solutionDescriptor.getListVariableDescriptor();
        boolean hasListVariable = listVariableDescriptor != null;
        int maxStepCount = -1;
        if (hasListVariable) {
            Object workingSolution = phaseScope.getWorkingSolution();
            maxStepCount = listVariableDescriptor.countUnassigned(workingSolution);
        }
        PossiblyInitializingPhase.TerminationStatus earlyTerminationStatus = null;
        while (this.moveRepository.hasNext()) {
            ConstructionHeuristicStepScope<Solution_> stepScope = new ConstructionHeuristicStepScope<Solution_>(phaseScope);
            this.stepStarted(stepScope);
            this.decider.decideNextStep(stepScope, this.moveRepository.iterator());
            if (stepScope.getStep() == null) {
                if (this.phaseTermination.isPhaseTerminated(phaseScope)) {
                    Level logLevel = Level.TRACE;
                    if (this.decider.isLoggingEnabled() && this.logger.isEnabledForLevel(logLevel)) {
                        this.logger.atLevel(logLevel).log("{}    Step index ({}), time spent ({}) terminated without picking a nextStep.", new Object[]{this.logIndentation, stepScope.getStepIndex(), stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow()});
                    }
                } else if (stepScope.getSelectedMoveCount() == 0L) {
                    Level logLevel = Level.WARN;
                    if (this.decider.isLoggingEnabled() && this.logger.isEnabledForLevel(logLevel)) {
                        this.logger.atLevel(logLevel).log("{}    No doable selected move at step index ({}), time spent ({}). Terminating phase early.", new Object[]{this.logIndentation, stepScope.getStepIndex(), stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow()});
                    }
                } else {
                    throw new IllegalStateException("The step index (" + stepScope.getStepIndex() + ") has selected move count (" + stepScope.getSelectedMoveCount() + ") but failed to pick a nextStep (" + String.valueOf(stepScope.getStep()) + ").");
                }
                earlyTerminationStatus = PossiblyInitializingPhase.TerminationStatus.early(phaseScope.getNextStepIndex());
                break;
            }
            this.doStep(stepScope);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
            if (hasListVariable && stepScope.getStepIndex() >= maxStepCount) {
                earlyTerminationStatus = PossiblyInitializingPhase.TerminationStatus.regular(phaseScope.getNextStepIndex());
                break;
            }
            if (!this.phaseTermination.isPhaseTerminated(phaseScope)) continue;
            earlyTerminationStatus = PossiblyInitializingPhase.TerminationStatus.early(phaseScope.getNextStepIndex());
            break;
        }
        this.terminationStatus = DefaultConstructionHeuristicPhase.translateEarlyTermination(phaseScope, earlyTerminationStatus, this.moveRepository.hasNext());
        this.phaseEnded(phaseScope);
    }

    protected ConstructionHeuristicPhaseScope<Solution_> buildPhaseScope(SolverScope<Solution_> solverScope, int phaseIndex) {
        return new ConstructionHeuristicPhaseScope<Solution_>(solverScope, phaseIndex);
    }

    protected void doStep(ConstructionHeuristicStepScope<Solution_> stepScope) {
        Move<Solution_> step = stepScope.getStep();
        stepScope.getScoreDirector().executeMove(step);
        this.predictWorkingStepScore(stepScope, step);
        if (!this.isNested()) {
            this.processWorkingSolutionDuringStep(stepScope);
        }
    }

    private void processWorkingSolutionDuringStep(ConstructionHeuristicStepScope<Solution_> stepScope) {
        AbstractSolver solver = stepScope.getPhaseScope().getSolverScope().getSolver();
        solver.getBestSolutionRecaller().processWorkingSolutionDuringConstructionHeuristicsStep(stepScope);
    }

    @Override
    public void solvingStarted(SolverScope<Solution_> solverScope) {
        super.solvingStarted(solverScope);
        this.moveRepository.solvingStarted(solverScope);
        this.decider.solvingStarted(solverScope);
    }

    @Override
    public void phaseStarted(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.terminationStatus = PossiblyInitializingPhase.TerminationStatus.NOT_TERMINATED;
        this.moveRepository.phaseStarted(phaseScope);
        this.decider.phaseStarted(phaseScope);
    }

    @Override
    public void stepStarted(ConstructionHeuristicStepScope<Solution_> stepScope) {
        super.stepStarted(stepScope);
        this.moveRepository.stepStarted(stepScope);
        this.decider.stepStarted(stepScope);
    }

    @Override
    public void stepEnded(ConstructionHeuristicStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        this.moveRepository.stepEnded(stepScope);
        this.decider.stepEnded(stepScope);
        if (this.decider.isLoggingEnabled() && this.logger.isDebugEnabled()) {
            long timeMillisSpent = stepScope.getPhaseScope().calculateSolverTimeMillisSpentUpToNow();
            this.logger.debug("{}    CH step ({}), time spent ({}), score ({}), selected move count ({}), picked move ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), timeMillisSpent, stepScope.getScore(), stepScope.getSelectedMoveCount(), stepScope.getStepString()});
        }
    }

    @Override
    public void phaseEnded(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.ensureCorrectTermination(phaseScope, this.logger);
        this.updateBestSolutionAndFire(phaseScope);
        this.moveRepository.phaseEnded(phaseScope);
        this.decider.phaseEnded(phaseScope);
        phaseScope.endingNow();
        if (this.decider.isLoggingEnabled() && this.logger.isInfoEnabled()) {
            this.logger.info("{}Construction Heuristic phase ({}) ended: time spent ({}), best score ({}), move evaluation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseMoveEvaluationSpeed(), phaseScope.getNextStepIndex()});
        }
    }

    private void updateBestSolutionAndFire(ConstructionHeuristicPhaseScope<Solution_> phaseScope) {
        if (!this.isNested() && !phaseScope.getStartingScore().equals(phaseScope.getBestScore())) {
            AbstractSolver solver = phaseScope.getSolverScope().getSolver();
            solver.getBestSolutionRecaller().updateBestSolutionAndFire(phaseScope.getSolverScope());
        }
    }

    @Override
    public void solvingEnded(SolverScope<Solution_> solverScope) {
        super.solvingEnded(solverScope);
        this.moveRepository.solvingEnded(solverScope);
        this.decider.solvingEnded(solverScope);
    }

    @Override
    public void solvingError(SolverScope<Solution_> solverScope, Exception exception) {
        super.solvingError(solverScope, exception);
        this.decider.solvingError(solverScope, exception);
    }

    public static class DefaultConstructionHeuristicPhaseBuilder<Solution_>
    extends AbstractPossiblyInitializingPhase.AbstractPossiblyInitializingPhaseBuilder<Solution_> {
        private final EntityPlacer<Solution_> entityPlacer;
        private final ConstructionHeuristicDecider<Solution_> decider;

        public DefaultConstructionHeuristicPhaseBuilder(int phaseIndex, boolean lastInitializingPhase, String logIndentation, PhaseTermination<Solution_> phaseTermination, EntityPlacer<Solution_> entityPlacer, ConstructionHeuristicDecider<Solution_> decider) {
            super(phaseIndex, lastInitializingPhase, logIndentation, phaseTermination);
            this.entityPlacer = entityPlacer;
            this.decider = decider;
        }

        @Override
        public DefaultConstructionHeuristicPhaseBuilder<Solution_> enableAssertions(EnvironmentMode environmentMode) {
            super.enableAssertions(environmentMode);
            return this;
        }

        public EntityPlacer<Solution_> getEntityPlacer() {
            return this.entityPlacer;
        }

        @Override
        public DefaultConstructionHeuristicPhase<Solution_> build() {
            return new DefaultConstructionHeuristicPhase(this);
        }
    }
}

