/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.bavet.tri;

import ai.timefold.solver.core.api.function.TriFunction;
import ai.timefold.solver.core.impl.bavet.common.AbstractMapNode;
import ai.timefold.solver.core.impl.bavet.common.tuple.TriTuple;
import ai.timefold.solver.core.impl.bavet.common.tuple.TupleLifecycle;
import ai.timefold.solver.core.impl.bavet.common.tuple.UniTuple;
import java.util.Objects;

public final class MapTriToUniNode<A, B, C, NewA>
extends AbstractMapNode<TriTuple<A, B, C>, UniTuple<NewA>> {
    private final TriFunction<A, B, C, NewA> mappingFunction;

    public MapTriToUniNode(int mapStoreIndex, TriFunction<A, B, C, NewA> mappingFunction, TupleLifecycle<UniTuple<NewA>> nextNodesTupleLifecycle, int outputStoreSize) {
        super(mapStoreIndex, nextNodesTupleLifecycle, outputStoreSize);
        this.mappingFunction = Objects.requireNonNull(mappingFunction);
    }

    @Override
    protected UniTuple<NewA> map(TriTuple<A, B, C> tuple) {
        Object factA = tuple.factA;
        Object factB = tuple.factB;
        Object factC = tuple.factC;
        return new UniTuple<NewA>(this.mappingFunction.apply(factA, factB, factC), this.outputStoreSize);
    }

    @Override
    protected void remap(TriTuple<A, B, C> inTuple, UniTuple<NewA> outTuple) {
        Object factA = inTuple.factA;
        Object factB = inTuple.factB;
        Object factC = inTuple.factC;
        NewA newA = this.mappingFunction.apply(factA, factB, factC);
        outTuple.factA = newA;
    }
}

