/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.util;

import ai.timefold.solver.core.api.domain.common.DomainAccessType;
import ai.timefold.solver.core.api.domain.lookup.PlanningId;
import ai.timefold.solver.core.config.AbstractConfig;
import ai.timefold.solver.core.impl.domain.common.AlphabeticMemberComparator;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ConfigUtils {
    private static final AlphabeticMemberComparator alphabeticMemberComparator = new AlphabeticMemberComparator();

    public static <T> @NonNull T newInstance(@Nullable Object configBean, @NonNull String propertyName, @NonNull Class<T> clazz) {
        return ConfigUtils.newInstance(() -> configBean == null ? "?" : configBean.getClass().getSimpleName(), propertyName, clazz);
    }

    public static <T> @NonNull T newInstance(@NonNull Supplier<String> ownerDescriptor, @NonNull String propertyName, @NonNull Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("The %s's %s (%s) does not have a public no-arg constructor%s".formatted(ownerDescriptor.get(), propertyName, clazz.getName(), (clazz.isLocalClass() || clazz.isAnonymousClass() || clazz.isMemberClass()) && !Modifier.isStatic(clazz.getModifiers()) ? " because it is an inner class." : "."), e);
        }
    }

    public static void applyCustomProperties(@NonNull Object bean, @NonNull String beanClassPropertyName, @Nullable Map<@NonNull String, @NonNull String> customProperties, @NonNull String customPropertiesPropertyName) {
        if (customProperties == null) {
            return;
        }
        Class<?> beanClass = bean.getClass();
        customProperties.forEach((propertyName, valueString) -> {
            Object typedValue;
            Method setterMethod;
            block14: {
                setterMethod = ReflectionHelper.getSetterMethod(beanClass, propertyName);
                if (setterMethod == null) {
                    throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " cannot be set on the " + beanClassPropertyName + " (" + String.valueOf(beanClass) + ") because that class has no public setter for that property.\nMaybe add a public setter for that custom property (" + propertyName + ") on that class (" + beanClass.getSimpleName() + ").\nMaybe don't configure that custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + ".");
                }
                Class<?> propertyType = setterMethod.getParameterTypes()[0];
                try {
                    if (propertyType.equals(String.class)) {
                        typedValue = valueString;
                        break block14;
                    }
                    if (propertyType.equals(Boolean.TYPE) || propertyType.equals(Boolean.class)) {
                        typedValue = Boolean.parseBoolean(valueString);
                        break block14;
                    }
                    if (propertyType.equals(Integer.TYPE) || propertyType.equals(Integer.class)) {
                        typedValue = Integer.parseInt(valueString);
                        break block14;
                    }
                    if (propertyType.equals(Long.TYPE) || propertyType.equals(Long.class)) {
                        typedValue = Long.parseLong(valueString);
                        break block14;
                    }
                    if (propertyType.equals(Float.TYPE) || propertyType.equals(Float.class)) {
                        typedValue = Float.valueOf(Float.parseFloat(valueString));
                        break block14;
                    }
                    if (propertyType.equals(Double.TYPE) || propertyType.equals(Double.class)) {
                        typedValue = Double.parseDouble(valueString);
                        break block14;
                    }
                    if (propertyType.equals(BigDecimal.class)) {
                        typedValue = new BigDecimal((String)valueString);
                        break block14;
                    }
                    if (propertyType.isEnum()) {
                        typedValue = Enum.valueOf(propertyType, valueString);
                        break block14;
                    }
                    throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " has an unsupported propertyType (" + String.valueOf(propertyType) + ") for value (" + valueString + ").");
                }
                catch (NumberFormatException e) {
                    throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " cannot be parsed to the propertyType (" + String.valueOf(propertyType) + ") of the setterMethod (" + String.valueOf(setterMethod) + ").");
                }
            }
            try {
                setterMethod.invoke(bean, typedValue);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " has a setterMethod (" + String.valueOf(setterMethod) + ") on the beanClass (" + String.valueOf(beanClass) + ") that cannot be called for the typedValue (" + String.valueOf(typedValue) + ").", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("The custom property " + propertyName + " (" + valueString + ") in the " + customPropertiesPropertyName + " has a setterMethod (" + String.valueOf(setterMethod) + ") on the beanClass (" + String.valueOf(beanClass) + ") that throws an exception for the typedValue (" + String.valueOf(typedValue) + ").", e.getCause());
            }
        });
    }

    public static <Config_ extends AbstractConfig<Config_>> @Nullable Config_ inheritConfig(@Nullable Config_ original, @Nullable Config_ inherited) {
        if (inherited != null) {
            if (original == null) {
                original = inherited.copyConfig();
            } else {
                original.inherit(inherited);
            }
        }
        return original;
    }

    public static <Config_ extends AbstractConfig<Config_>> @Nullable List<Config_> inheritMergeableListConfig(@Nullable List<Config_> originalList, @Nullable List<Config_> inheritedList) {
        if (inheritedList != null) {
            ArrayList<Config_> mergedList = new ArrayList<Config_>(inheritedList.size() + (originalList == null ? 0 : originalList.size()));
            for (AbstractConfig inherited : inheritedList) {
                Object copy = inherited.copyConfig();
                mergedList.add(copy);
            }
            if (originalList != null) {
                mergedList.addAll(originalList);
            }
            originalList = mergedList;
        }
        return originalList;
    }

    public static <T> @Nullable T inheritOverwritableProperty(@Nullable T original, @Nullable T inherited) {
        if (original != null) {
            return original;
        }
        return inherited;
    }

    public static <T> @Nullable List<T> inheritMergeableListProperty(@Nullable List<T> originalList, @Nullable List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return new ArrayList<T>(inheritedList);
        }
        ArrayList<T> mergedList = new ArrayList<T>(inheritedList);
        mergedList.addAll(originalList);
        return mergedList;
    }

    public static <E extends Enum<E>> @Nullable Set<E> inheritMergeableEnumSetProperty(@Nullable Set<E> originalSet, @Nullable Set<E> inheritedSet) {
        if (inheritedSet == null) {
            return originalSet;
        }
        if (originalSet == null) {
            return EnumSet.copyOf(inheritedSet);
        }
        EnumSet<E> newSet = EnumSet.copyOf(originalSet);
        newSet.addAll(inheritedSet);
        return newSet;
    }

    public static <T> @Nullable List<T> inheritUniqueMergeableListProperty(@Nullable List<T> originalList, @Nullable List<T> inheritedList) {
        if (inheritedList == null) {
            return originalList;
        }
        if (originalList == null) {
            return new ArrayList<T>(inheritedList);
        }
        LinkedHashSet<T> mergedSet = new LinkedHashSet<T>(inheritedList);
        mergedSet.addAll(originalList);
        return new ArrayList<T>(mergedSet);
    }

    public static <K, T> @Nullable Map<K, T> inheritMergeableMapProperty(@Nullable Map<K, T> originalMap, @Nullable Map<K, T> inheritedMap) {
        if (inheritedMap == null) {
            return originalMap;
        }
        if (originalMap == null) {
            return inheritedMap;
        }
        LinkedHashMap<K, T> mergedMap = new LinkedHashMap<K, T>(inheritedMap);
        mergedMap.putAll(originalMap);
        return mergedMap;
    }

    public static <T> @Nullable T mergeProperty(@Nullable T a, @Nullable T b) {
        return (T)(Objects.equals(a, b) ? a : null);
    }

    public static <T> @Nullable T meldProperty(@Nullable T a, @Nullable T b) {
        if (a == null && b == null) {
            return null;
        }
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return ConfigUtils.mergeProperty(a, b);
    }

    public static boolean isEmptyCollection(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static int ceilDivide(int dividend, int divisor) {
        if (divisor == 0) {
            throw new ArithmeticException("Cannot divide by zero: " + dividend + "/" + divisor);
        }
        int correction = dividend % divisor == 0 ? 0 : (Integer.signum(dividend) * Integer.signum(divisor) < 0 ? 0 : 1);
        return dividend / divisor + correction;
    }

    public static int resolvePoolSize(@NonNull String propertyName, @NonNull String value, String ... magicValues) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new IllegalStateException("The " + propertyName + " (" + value + ") resolved to neither of (" + Arrays.toString(magicValues) + ") nor a number.");
        }
    }

    public static @NonNull List<@NonNull Class<?>> getAllParents(@Nullable Class<?> bottomClass) {
        if (bottomClass == null || bottomClass == Object.class) {
            return Collections.emptyList();
        }
        Class<?> superclass = bottomClass.getSuperclass();
        ArrayList lineageClassList = new ArrayList(ConfigUtils.getAllParents(superclass));
        for (Class<?> superInterface : bottomClass.getInterfaces()) {
            lineageClassList.addAll(ConfigUtils.getAllParents(superInterface));
        }
        lineageClassList.add(bottomClass);
        return lineageClassList;
    }

    public static @NonNull List<@NonNull Class<?>> getAllAnnotatedLineageClasses(@Nullable Class<?> bottomClass, @NonNull Class<? extends Annotation> annotation) {
        if (bottomClass == null || !bottomClass.isAnnotationPresent(annotation)) {
            return Collections.emptyList();
        }
        ArrayList lineageClassList = new ArrayList();
        lineageClassList.add(bottomClass);
        Class<?> superclass = bottomClass.getSuperclass();
        lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superclass, annotation));
        for (Class<?> superInterface : bottomClass.getInterfaces()) {
            lineageClassList.addAll(ConfigUtils.getAllAnnotatedLineageClasses(superInterface, annotation));
        }
        return lineageClassList;
    }

    public static @NonNull List<Member> getDeclaredMembers(@NonNull Class<?> baseClass) {
        Stream<Field> fieldStream = Stream.of(baseClass.getDeclaredFields()).filter(field -> !field.isSynthetic()).sorted(alphabeticMemberComparator);
        Stream<Method> methodStream = Stream.of(baseClass.getDeclaredMethods()).filter(method -> !method.isSynthetic()).sorted(alphabeticMemberComparator);
        return Stream.concat(fieldStream, methodStream).collect(Collectors.toList());
    }

    public static @NonNull List<Member> getAllMembers(@NonNull Class<?> baseClass, @NonNull Class<? extends Annotation> annotationClass) {
        Stream<Object> memberStream = Stream.empty();
        for (Class<?> clazz = baseClass; clazz != null; clazz = clazz.getSuperclass()) {
            Stream<Field> fieldStream = Stream.of(clazz.getDeclaredFields()).filter(field -> field.isAnnotationPresent(annotationClass) && !field.isSynthetic());
            Stream<Method> methodStream = Stream.concat(Stream.of(clazz.getDeclaredMethods()), Arrays.stream(clazz.getInterfaces()).flatMap(implementedInterface -> Arrays.stream(implementedInterface.getMethods()))).filter(method -> method.isAnnotationPresent(annotationClass) && !method.isSynthetic());
            memberStream = Stream.concat(memberStream, Stream.concat(fieldStream, methodStream));
        }
        return memberStream.distinct().sorted(alphabeticMemberComparator).collect(Collectors.toList());
    }

    @SafeVarargs
    public static Class<? extends Annotation> extractAnnotationClass(@NonNull Member member, Class<? extends Annotation> ... annotationClasses) {
        Class<? extends Annotation> annotationClass = null;
        for (Class<? extends Annotation> detectedAnnotationClass : annotationClasses) {
            if (!((AnnotatedElement)((Object)member)).isAnnotationPresent(detectedAnnotationClass)) continue;
            if (annotationClass != null) {
                throw new IllegalStateException("The class (" + String.valueOf(member.getDeclaringClass()) + ") has a member (" + String.valueOf(member) + ") that has both a @" + annotationClass.getSimpleName() + " annotation and a @" + detectedAnnotationClass.getSimpleName() + " annotation.");
            }
            annotationClass = detectedAnnotationClass;
        }
        return annotationClass;
    }

    public static Class<?> extractGenericTypeParameterOrFail(@NonNull String parentClassConcept, @NonNull Class<?> parentClass, @NonNull Class<?> type, @NonNull Type genericType, @Nullable Class<? extends Annotation> annotationClass, @NonNull String memberName) {
        return ConfigUtils.extractGenericTypeParameter(parentClassConcept, parentClass, type, genericType, annotationClass, memberName).orElseThrow(() -> new IllegalArgumentException("The %s (%s) has a %s member (%s) with a member type (%s) which has no generic parameters.\nMaybe the member (%s) should return a parameterized %s.".formatted(parentClassConcept, parentClass, annotationClass == null ? "auto discovered" : "@" + annotationClass.getSimpleName() + " annotated", memberName, type, memberName, type.getSimpleName())));
    }

    public static Optional<Class<?>> extractGenericTypeParameter(@NonNull String parentClassConcept, @NonNull Class<?> parentClass, @NonNull Class<?> type, @NonNull Type genericType, @Nullable Class<? extends Annotation> annotationClass, @NonNull String memberName) {
        if (!(genericType instanceof ParameterizedType)) {
            return Optional.empty();
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        if (typeArguments.length != 1) {
            throw new IllegalArgumentException("The %s (%s) has a %s member (%s) with a member type (%s) which is a parameterized collection with an unsupported number of generic parameters (%s).".formatted(parentClassConcept, parentClass, annotationClass == null ? "auto discovered" : "@" + annotationClass.getSimpleName() + " annotated", memberName, type, typeArguments.length));
        }
        Object typeArgument = typeArguments[0];
        if (typeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedTypeArgument = (ParameterizedType)typeArgument;
            typeArgument = parameterizedTypeArgument.getRawType();
        }
        if (typeArgument instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)typeArgument;
            Object[] upperBounds = wildcardType.getUpperBounds();
            typeArgument = switch (upperBounds.length) {
                case 0 -> Object.class;
                case 1 -> upperBounds[0];
                default -> throw new IllegalArgumentException("The %s (%s) has a %s  member (%s) with a member type (%s) which is a parameterized collection with a wildcard type argument (%s) that has multiple upper bounds (%s).\nMaybe don't use wildcards with multiple upper bounds for the member (%s).".formatted(parentClassConcept, parentClass, annotationClass == null ? "auto discovered" : "@" + annotationClass.getSimpleName() + " annotated", memberName, type, typeArgument, Arrays.toString(upperBounds), memberName));
            };
        }
        if (typeArgument instanceof Class) {
            Class class1 = (Class)typeArgument;
            return Optional.of(class1);
        }
        if (typeArgument instanceof ParameterizedType) {
            ParameterizedType parameterizedTypeArgument = (ParameterizedType)typeArgument;
            return Optional.of((Class)parameterizedTypeArgument.getRawType());
        }
        throw new IllegalArgumentException("The %s (%s) has a %s member (%s) with a member type (%s) which is a parameterized collection with a type argument (%s) that is not a class or interface.".formatted(parentClassConcept, parentClass, annotationClass == null ? "auto discovered" : "@" + annotationClass.getSimpleName() + " annotated", memberName, type, typeArgument));
    }

    public static <C> @Nullable MemberAccessor findPlanningIdMemberAccessor(@NonNull Class<C> clazz, @NonNull MemberAccessorFactory memberAccessorFactory, @NonNull DomainAccessType domainAccessType) {
        Member member = ConfigUtils.getSingleMember(clazz, PlanningId.class);
        if (member == null) {
            return null;
        }
        MemberAccessor memberAccessor = memberAccessorFactory.buildAndCacheMemberAccessor(member, MemberAccessorFactory.MemberAccessorType.FIELD_OR_READ_METHOD, PlanningId.class, domainAccessType);
        ConfigUtils.assertPlanningIdMemberIsComparable(clazz, member, memberAccessor);
        return memberAccessor;
    }

    private static void assertPlanningIdMemberIsComparable(Class<?> clazz, Member member, MemberAccessor memberAccessor) {
        if (!memberAccessor.getType().isPrimitive() && !Comparable.class.isAssignableFrom(memberAccessor.getType())) {
            throw new IllegalArgumentException("The class (" + String.valueOf(clazz) + ") has a member (" + String.valueOf(member) + ") with a @" + PlanningId.class.getSimpleName() + " annotation that returns a type (" + String.valueOf(memberAccessor.getType()) + ") that does not implement " + Comparable.class.getSimpleName() + ".\nMaybe use a " + Long.class.getSimpleName() + " or " + String.class.getSimpleName() + " type instead.");
        }
    }

    private static <C> Member getSingleMember(Class<C> clazz, Class<? extends Annotation> annotationClass) {
        List<Member> memberList = ConfigUtils.getAllMembers(clazz, annotationClass);
        if (memberList.isEmpty()) {
            return null;
        }
        int size = memberList.size();
        if (clazz.isRecord()) {
            if (size == 2) {
                List<Member> methodMembers = ConfigUtils.getMembers(memberList, true);
                if (methodMembers.isEmpty()) {
                    throw new IllegalStateException("Impossible state: record (%s) doesn't have any method members (%s).".formatted(clazz.getCanonicalName(), memberList));
                }
                return methodMembers.get(0);
            }
            List<String> componentList = ConfigUtils.getMembers(memberList, false).stream().map(Member::getName).toList();
            throw new IllegalArgumentException("The record (%s) has %s components (%s) with %s annotation.".formatted(clazz, componentList.size(), componentList, annotationClass.getSimpleName()));
        }
        if (size > 1) {
            throw new IllegalArgumentException("The class (%s) has %s members (%s) with %s annotation.".formatted(clazz, memberList.size(), memberList, annotationClass.getSimpleName()));
        }
        return memberList.get(0);
    }

    private static List<Member> getMembers(List<Member> memberList, boolean needMethod) {
        ArrayList<Member> filteredMemberList = new ArrayList<Member>(memberList.size());
        for (Member member : memberList) {
            if (member instanceof Method && needMethod) {
                filteredMemberList.add(member);
                continue;
            }
            if (!(member instanceof Field) || needMethod) continue;
            filteredMemberList.add(member);
        }
        return filteredMemberList;
    }

    public static @NonNull String abbreviate(@Nullable List<@Nullable String> list, int limit) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        Object abbreviation = list.stream().limit(limit).collect(Collectors.joining(", "));
        if (list.size() > limit) {
            abbreviation = (String)abbreviation + ", ...";
        }
        return abbreviation;
    }

    public static @NonNull String abbreviate(@Nullable List<@Nullable String> list) {
        return ConfigUtils.abbreviate(list, 3);
    }

    private ConfigUtils() {
    }
}

