/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score.buildin.hardsoftbigdecimal;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.ScoreUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

public final class HardSoftBigDecimalScore
implements Score<HardSoftBigDecimalScore> {
    public static final @NonNull HardSoftBigDecimalScore ZERO = new HardSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ZERO);
    public static final @NonNull HardSoftBigDecimalScore ONE_HARD = new HardSoftBigDecimalScore(0, BigDecimal.ONE, BigDecimal.ZERO);
    public static final @NonNull HardSoftBigDecimalScore ONE_SOFT = new HardSoftBigDecimalScore(0, BigDecimal.ZERO, BigDecimal.ONE);
    private final int initScore;
    private final @NonNull BigDecimal hardScore;
    private final @NonNull BigDecimal softScore;

    public static @NonNull HardSoftBigDecimalScore parseScore(@NonNull String scoreString) {
        String[] scoreTokens = ScoreUtil.parseScoreTokens(HardSoftBigDecimalScore.class, scoreString, "hard", "soft");
        int initScore = ScoreUtil.parseInitScore(HardSoftBigDecimalScore.class, scoreString, scoreTokens[0]);
        BigDecimal hardScore = ScoreUtil.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, scoreTokens[1]);
        BigDecimal softScore = ScoreUtil.parseLevelAsBigDecimal(HardSoftBigDecimalScore.class, scoreString, scoreTokens[2]);
        return HardSoftBigDecimalScore.ofUninitialized(initScore, hardScore, softScore);
    }

    public static @NonNull HardSoftBigDecimalScore ofUninitialized(int initScore, @NonNull BigDecimal hardScore, @NonNull BigDecimal softScore) {
        if (initScore == 0) {
            return HardSoftBigDecimalScore.of(hardScore, softScore);
        }
        return new HardSoftBigDecimalScore(initScore, hardScore, softScore);
    }

    public static @NonNull HardSoftBigDecimalScore of(BigDecimal hardScore, BigDecimal softScore) {
        if (hardScore.signum() == 0) {
            if (softScore.signum() == 0) {
                return ZERO;
            }
            if (Objects.equals(softScore, BigDecimal.ONE)) {
                return ONE_SOFT;
            }
        } else if (Objects.equals(hardScore, BigDecimal.ONE) && softScore.signum() == 0) {
            return ONE_HARD;
        }
        return new HardSoftBigDecimalScore(0, hardScore, softScore);
    }

    public static @NonNull HardSoftBigDecimalScore ofHard(BigDecimal hardScore) {
        if (hardScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(hardScore, BigDecimal.ONE)) {
            return ONE_HARD;
        }
        return new HardSoftBigDecimalScore(0, hardScore, BigDecimal.ZERO);
    }

    public static @NonNull HardSoftBigDecimalScore ofSoft(BigDecimal softScore) {
        if (softScore.signum() == 0) {
            return ZERO;
        }
        if (Objects.equals(softScore, BigDecimal.ONE)) {
            return ONE_SOFT;
        }
        return new HardSoftBigDecimalScore(0, BigDecimal.ZERO, softScore);
    }

    private HardSoftBigDecimalScore() {
        this(Integer.MIN_VALUE, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private HardSoftBigDecimalScore(int initScore, @NonNull BigDecimal hardScore, @NonNull BigDecimal softScore) {
        this.initScore = initScore;
        this.hardScore = hardScore;
        this.softScore = softScore;
    }

    @Override
    public int initScore() {
        return this.initScore;
    }

    public @NonNull BigDecimal hardScore() {
        return this.hardScore;
    }

    @Deprecated(forRemoval=true)
    public @NonNull BigDecimal getHardScore() {
        return this.hardScore;
    }

    public @NonNull BigDecimal softScore() {
        return this.softScore;
    }

    @Deprecated(forRemoval=true)
    public @NonNull BigDecimal getSoftScore() {
        return this.softScore;
    }

    @Override
    public @NonNull HardSoftBigDecimalScore withInitScore(int newInitScore) {
        return new HardSoftBigDecimalScore(newInitScore, this.hardScore, this.softScore);
    }

    @Override
    public boolean isFeasible() {
        return this.initScore >= 0 && this.hardScore.signum() >= 0;
    }

    @Override
    public @NonNull HardSoftBigDecimalScore add(@NonNull HardSoftBigDecimalScore addend) {
        return HardSoftBigDecimalScore.ofUninitialized(this.initScore + addend.initScore(), this.hardScore.add(addend.hardScore()), this.softScore.add(addend.softScore()));
    }

    @Override
    public @NonNull HardSoftBigDecimalScore subtract(@NonNull HardSoftBigDecimalScore subtrahend) {
        return HardSoftBigDecimalScore.ofUninitialized(this.initScore - subtrahend.initScore(), this.hardScore.subtract(subtrahend.hardScore()), this.softScore.subtract(subtrahend.softScore()));
    }

    @Override
    public @NonNull HardSoftBigDecimalScore multiply(double multiplicand) {
        BigDecimal multiplicandBigDecimal = BigDecimal.valueOf(multiplicand);
        return HardSoftBigDecimalScore.ofUninitialized((int)Math.floor((double)this.initScore * multiplicand), this.hardScore.multiply(multiplicandBigDecimal).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.multiply(multiplicandBigDecimal).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull HardSoftBigDecimalScore divide(double divisor) {
        BigDecimal divisorBigDecimal = BigDecimal.valueOf(divisor);
        return HardSoftBigDecimalScore.ofUninitialized((int)Math.floor((double)this.initScore / divisor), this.hardScore.divide(divisorBigDecimal, this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.divide(divisorBigDecimal, this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull HardSoftBigDecimalScore power(double exponent) {
        BigDecimal exponentBigDecimal = BigDecimal.valueOf(exponent);
        return HardSoftBigDecimalScore.ofUninitialized((int)Math.floor(Math.pow(this.initScore, exponent)), this.hardScore.pow(exponentBigDecimal.intValue()).setScale(this.hardScore.scale(), RoundingMode.FLOOR), this.softScore.pow(exponentBigDecimal.intValue()).setScale(this.softScore.scale(), RoundingMode.FLOOR));
    }

    @Override
    public @NonNull HardSoftBigDecimalScore abs() {
        return HardSoftBigDecimalScore.ofUninitialized(Math.abs(this.initScore), this.hardScore.abs(), this.softScore.abs());
    }

    @Override
    public @NonNull HardSoftBigDecimalScore zero() {
        return ZERO;
    }

    @Override
    public Number @NonNull [] toLevelNumbers() {
        return new Number[]{this.hardScore, this.softScore};
    }

    public boolean equals(Object o) {
        if (o instanceof HardSoftBigDecimalScore) {
            HardSoftBigDecimalScore other = (HardSoftBigDecimalScore)o;
            return this.initScore == other.initScore() && this.hardScore.stripTrailingZeros().equals(other.hardScore().stripTrailingZeros()) && this.softScore.stripTrailingZeros().equals(other.softScore().stripTrailingZeros());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.initScore, this.hardScore.stripTrailingZeros(), this.softScore.stripTrailingZeros());
    }

    @Override
    public int compareTo(@NonNull HardSoftBigDecimalScore other) {
        if (this.initScore != other.initScore()) {
            return Integer.compare(this.initScore, other.initScore());
        }
        int hardScoreComparison = this.hardScore.compareTo(other.hardScore());
        if (hardScoreComparison != 0) {
            return hardScoreComparison;
        }
        return this.softScore.compareTo(other.softScore());
    }

    @Override
    public @NonNull String toShortString() {
        return ScoreUtil.buildShortString(this, n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0, "hard", "soft");
    }

    public String toString() {
        return ScoreUtil.getInitPrefix(this.initScore) + String.valueOf(this.hardScore) + "hard/" + String.valueOf(this.softScore) + "soft";
    }
}

