/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.api.score;

import java.io.Serializable;
import org.jspecify.annotations.NonNull;

public interface Score<Score_ extends Score<Score_>>
extends Comparable<Score_>,
Serializable {
    default public int initScore() {
        return this.getInitScore();
    }

    @Deprecated(forRemoval=true)
    default public int getInitScore() {
        return this.initScore();
    }

    public @NonNull Score_ withInitScore(int var1);

    public @NonNull Score_ add(@NonNull Score_ var1);

    public @NonNull Score_ subtract(@NonNull Score_ var1);

    public @NonNull Score_ multiply(double var1);

    public @NonNull Score_ divide(double var1);

    public @NonNull Score_ power(double var1);

    default public @NonNull Score_ negate() {
        Score current;
        Score zero = this.zero();
        if (zero.equals(current = this)) {
            return (Score_)current;
        }
        return (Score_)zero.subtract((Score)current);
    }

    public @NonNull Score_ abs();

    public @NonNull Score_ zero();

    default public boolean isZero() {
        return this.equals(this.zero());
    }

    public @NonNull Number @NonNull [] toLevelNumbers();

    default public double @NonNull [] toLevelDoubles() {
        Number[] levelNumbers = this.toLevelNumbers();
        double[] levelDoubles = new double[levelNumbers.length];
        for (int i = 0; i < levelNumbers.length; ++i) {
            levelDoubles[i] = levelNumbers[i].doubleValue();
        }
        return levelDoubles;
    }

    default public boolean isSolutionInitialized() {
        return this.initScore() >= 0;
    }

    public boolean isFeasible();

    public @NonNull String toShortString();
}

