/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractTermination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.time.Clock;

public class UnimprovedTimeMillisSpentTermination<Solution_>
extends AbstractTermination<Solution_> {
    private final long unimprovedTimeMillisSpentLimit;
    private final Clock clock;

    public UnimprovedTimeMillisSpentTermination(long unimprovedTimeMillisSpentLimit) {
        this(unimprovedTimeMillisSpentLimit, Clock.systemUTC());
    }

    protected UnimprovedTimeMillisSpentTermination(long unimprovedTimeMillisSpentLimit, Clock clock) {
        this.unimprovedTimeMillisSpentLimit = unimprovedTimeMillisSpentLimit;
        if (unimprovedTimeMillisSpentLimit < 0L) {
            throw new IllegalArgumentException("The unimprovedTimeMillisSpentLimit (" + unimprovedTimeMillisSpentLimit + ") cannot be negative.");
        }
        this.clock = clock;
    }

    public long getUnimprovedTimeMillisSpentLimit() {
        return this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
        return this.isTerminated(bestSolutionTimeMillis);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        long bestSolutionTimeMillis = phaseScope.getPhaseBestSolutionTimeMillis();
        return this.isTerminated(bestSolutionTimeMillis);
    }

    protected boolean isTerminated(long bestSolutionTimeMillis) {
        long now = this.clock.millis();
        long unimprovedTimeMillisSpent = now - bestSolutionTimeMillis;
        return unimprovedTimeMillisSpent >= this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
        return this.calculateTimeGradient(bestSolutionTimeMillis);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        long bestSolutionTimeMillis = phaseScope.getPhaseBestSolutionTimeMillis();
        return this.calculateTimeGradient(bestSolutionTimeMillis);
    }

    protected double calculateTimeGradient(long bestSolutionTimeMillis) {
        long now = this.clock.millis();
        long unimprovedTimeMillisSpent = now - bestSolutionTimeMillis;
        double timeGradient = (double)unimprovedTimeMillisSpent / (double)this.unimprovedTimeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public UnimprovedTimeMillisSpentTermination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return new UnimprovedTimeMillisSpentTermination<Solution_>(this.unimprovedTimeMillisSpentLimit);
    }

    public String toString() {
        return "UnimprovedTimeMillisSpent(" + this.unimprovedTimeMillisSpentLimit + ")";
    }
}

