/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver.termination;

import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.solver.change.ProblemChangeAdapter;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.AbstractTermination;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import ai.timefold.solver.core.impl.solver.thread.ChildThreadType;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class BasicPlumbingTermination<Solution_>
extends AbstractTermination<Solution_> {
    protected final boolean daemon;
    protected boolean terminatedEarly = false;
    protected BlockingQueue<ProblemChangeAdapter<Solution_>> problemFactChangeQueue = new LinkedBlockingQueue<ProblemChangeAdapter<Solution_>>();
    protected boolean problemFactChangesBeingProcessed = false;

    public BasicPlumbingTermination(boolean daemon) {
        this.daemon = daemon;
    }

    public synchronized void resetTerminateEarly() {
        this.terminatedEarly = false;
    }

    public synchronized boolean terminateEarly() {
        boolean terminationEarlySuccessful = !this.terminatedEarly;
        this.terminatedEarly = true;
        this.notifyAll();
        return terminationEarlySuccessful;
    }

    public synchronized boolean isTerminateEarly() {
        return this.terminatedEarly;
    }

    public synchronized boolean waitForRestartSolverDecision() {
        if (!this.daemon) {
            return !this.problemFactChangeQueue.isEmpty() && !this.terminatedEarly;
        }
        while (this.problemFactChangeQueue.isEmpty() && !this.terminatedEarly) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("Solver thread was interrupted during Object.wait().", e);
            }
        }
        return !this.terminatedEarly;
    }

    public synchronized boolean addProblemChange(ProblemChangeAdapter<Solution_> problemChange) {
        boolean added = this.problemFactChangeQueue.add(problemChange);
        this.notifyAll();
        return added;
    }

    public synchronized boolean addProblemChanges(List<ProblemChangeAdapter<Solution_>> problemChangeList) {
        boolean added = this.problemFactChangeQueue.addAll(problemChangeList);
        this.notifyAll();
        return added;
    }

    public synchronized BlockingQueue<ProblemChangeAdapter<Solution_>> startProblemFactChangesProcessing() {
        this.problemFactChangesBeingProcessed = true;
        return this.problemFactChangeQueue;
    }

    public synchronized void endProblemFactChangesProcessing() {
        this.problemFactChangesBeingProcessed = false;
    }

    public synchronized boolean isEveryProblemFactChangeProcessed() {
        return this.problemFactChangeQueue.isEmpty() && !this.problemFactChangesBeingProcessed;
    }

    @Override
    public synchronized boolean isSolverTerminated(SolverScope<Solution_> solverScope) {
        if (Thread.currentThread().isInterrupted() && !this.terminatedEarly) {
            this.logger.info("The solver thread got interrupted, so this solver is terminating early.");
            this.terminatedEarly = true;
        }
        return this.terminatedEarly || !this.problemFactChangeQueue.isEmpty();
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope<Solution_> phaseScope) {
        throw new IllegalStateException(BasicPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public double calculateSolverTimeGradient(SolverScope<Solution_> solverScope) {
        return -1.0;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope<Solution_> phaseScope) {
        throw new IllegalStateException(BasicPlumbingTermination.class.getSimpleName() + " configured only as solver termination. It is always bridged to phase termination.");
    }

    @Override
    public Termination<Solution_> createChildThreadTermination(SolverScope<Solution_> solverScope, ChildThreadType childThreadType) {
        return this;
    }

    public String toString() {
        return "BasicPlumbing()";
    }
}

