/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.solver;

import ai.timefold.solver.core.api.solver.Solver;
import ai.timefold.solver.core.api.solver.change.ProblemChange;
import ai.timefold.solver.core.impl.solver.BestSolutionContainingProblemChanges;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BooleanSupplier;

final class BestSolutionHolder<Solution_> {
    private final Lock problemChangesLock = new ReentrantLock();
    private final AtomicReference<VersionedBestSolution<Solution_>> versionedBestSolutionRef = new AtomicReference();
    private final SortedMap<BigInteger, List<CompletableFuture<Void>>> problemChangesPerVersion = new TreeMap<BigInteger, List<CompletableFuture<Void>>>();
    private BigInteger currentVersion = BigInteger.ZERO;

    BestSolutionHolder() {
    }

    boolean isEmpty() {
        return this.versionedBestSolutionRef.get() == null;
    }

    BestSolutionContainingProblemChanges<Solution_> take() {
        VersionedBestSolution versionedBestSolution = this.versionedBestSolutionRef.getAndSet(null);
        if (versionedBestSolution == null) {
            return null;
        }
        SortedMap<BigInteger, List<CompletableFuture<Void>>> containedProblemChangesPerVersion = this.problemChangesPerVersion.headMap(versionedBestSolution.getVersion().add(BigInteger.ONE));
        ArrayList<CompletableFuture<Void>> containedProblemChanges = new ArrayList<CompletableFuture<Void>>();
        for (Map.Entry<BigInteger, List<CompletableFuture<Void>>> entry : containedProblemChangesPerVersion.entrySet()) {
            containedProblemChanges.addAll((Collection<CompletableFuture<Void>>)entry.getValue());
            this.problemChangesPerVersion.remove(entry.getKey());
        }
        return new BestSolutionContainingProblemChanges(versionedBestSolution.getBestSolution(), containedProblemChanges);
    }

    void set(Solution_ bestSolution, BooleanSupplier isEveryProblemChangeProcessed) {
        this.problemChangesLock.lock();
        try {
            if (isEveryProblemChangeProcessed.getAsBoolean()) {
                this.versionedBestSolutionRef.set(new VersionedBestSolution<Solution_>(bestSolution, this.currentVersion));
                this.currentVersion = this.currentVersion.add(BigInteger.ONE);
            }
        }
        finally {
            this.problemChangesLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableFuture<Void> addProblemChange(Solver<Solution_> solver, ProblemChange<Solution_> problemChange) {
        this.problemChangesLock.lock();
        try {
            CompletableFuture<Void> futureProblemChange = new CompletableFuture<Void>();
            this.problemChangesPerVersion.compute(this.currentVersion, (version, futureProblemChangeList) -> {
                if (futureProblemChangeList == null) {
                    futureProblemChangeList = new ArrayList<CompletableFuture>();
                }
                futureProblemChangeList.add(futureProblemChange);
                return futureProblemChangeList;
            });
            solver.addProblemChange(problemChange);
            CompletableFuture<Void> completableFuture = futureProblemChange;
            return completableFuture;
        }
        finally {
            this.problemChangesLock.unlock();
        }
    }

    void cancelPendingChanges() {
        this.problemChangesLock.lock();
        try {
            this.problemChangesPerVersion.values().stream().flatMap(Collection::stream).forEach(pendingProblemChange -> pendingProblemChange.cancel(false));
            this.problemChangesPerVersion.clear();
        }
        finally {
            this.problemChangesLock.unlock();
        }
    }

    private static final class VersionedBestSolution<Solution_> {
        final Solution_ bestSolution;
        final BigInteger version;

        public VersionedBestSolution(Solution_ bestSolution, BigInteger version) {
            this.bestSolution = bestSolution;
            this.version = version;
        }

        public Solution_ getBestSolution() {
            return this.bestSolution;
        }

        public BigInteger getVersion() {
            return this.version;
        }
    }
}

