/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.director;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.stream.ConstraintStreamImplType;
import ai.timefold.solver.core.config.score.director.ScoreDirectorFactoryConfig;
import ai.timefold.solver.core.config.score.trend.InitializingScoreTrendLevel;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.score.director.AbstractScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactory;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorFactoryService;
import ai.timefold.solver.core.impl.score.director.ScoreDirectorType;
import ai.timefold.solver.core.impl.score.trend.InitializingScoreTrend;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScoreDirectorFactoryFactory<Solution_, Score_ extends Score<Score_>> {
    private final ScoreDirectorFactoryConfig config;

    public ScoreDirectorFactoryFactory(ScoreDirectorFactoryConfig config) {
        this.config = config;
    }

    public InnerScoreDirectorFactory<Solution_, Score_> buildScoreDirectorFactory(ClassLoader classLoader, EnvironmentMode environmentMode, SolutionDescriptor<Solution_> solutionDescriptor) {
        AbstractScoreDirectorFactory<Solution_, Score_> scoreDirectorFactory = this.decideMultipleScoreDirectorFactories(classLoader, solutionDescriptor, environmentMode);
        if (this.config.getAssertionScoreDirectorFactory() != null) {
            if (this.config.getAssertionScoreDirectorFactory().getAssertionScoreDirectorFactory() != null) {
                throw new IllegalArgumentException("A assertionScoreDirectorFactory (" + this.config.getAssertionScoreDirectorFactory() + ") cannot have a non-null assertionScoreDirectorFactory (" + this.config.getAssertionScoreDirectorFactory().getAssertionScoreDirectorFactory() + ").");
            }
            if (environmentMode.compareTo(EnvironmentMode.FAST_ASSERT) > 0) {
                throw new IllegalArgumentException("A non-null assertionScoreDirectorFactory (" + this.config.getAssertionScoreDirectorFactory() + ") requires an environmentMode (" + environmentMode + ") of " + EnvironmentMode.FAST_ASSERT + " or lower.");
            }
            ScoreDirectorFactoryFactory<Solution_, Score_> assertionScoreDirectorFactoryFactory = new ScoreDirectorFactoryFactory<Solution_, Score_>(this.config.getAssertionScoreDirectorFactory());
            scoreDirectorFactory.setAssertionScoreDirectorFactory(assertionScoreDirectorFactoryFactory.buildScoreDirectorFactory(classLoader, EnvironmentMode.NON_REPRODUCIBLE, solutionDescriptor));
        }
        scoreDirectorFactory.setInitializingScoreTrend(InitializingScoreTrend.parseTrend(this.config.getInitializingScoreTrend() == null ? InitializingScoreTrendLevel.ANY.name() : this.config.getInitializingScoreTrend(), solutionDescriptor.getScoreDefinition().getLevelsSize()));
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            scoreDirectorFactory.setAssertClonedSolution(true);
        }
        return scoreDirectorFactory;
    }

    protected AbstractScoreDirectorFactory<Solution_, Score_> decideMultipleScoreDirectorFactories(ClassLoader classLoader, SolutionDescriptor<Solution_> solutionDescriptor, EnvironmentMode environmentMode) {
        ServiceLoader<ScoreDirectorFactoryService> scoreDirectorFactoryServiceLoader = ServiceLoader.load(ScoreDirectorFactoryService.class);
        EnumMap scoreDirectorFactorySupplierMap = new EnumMap(ScoreDirectorType.class);
        for (ScoreDirectorFactoryService service : scoreDirectorFactoryServiceLoader) {
            Supplier factory = service.buildScoreDirectorFactory(classLoader, solutionDescriptor, this.config, environmentMode);
            if (factory == null) continue;
            scoreDirectorFactorySupplierMap.put(service.getSupportedScoreDirectorType(), factory);
        }
        Supplier easyScoreDirectorFactorySupplier = (Supplier)scoreDirectorFactorySupplierMap.get((Object)ScoreDirectorType.EASY);
        Supplier constraintStreamScoreDirectorFactorySupplier = (Supplier)scoreDirectorFactorySupplierMap.get((Object)ScoreDirectorType.CONSTRAINT_STREAMS);
        Supplier incrementalScoreDirectorFactorySupplier = (Supplier)scoreDirectorFactorySupplierMap.get((Object)ScoreDirectorType.INCREMENTAL);
        Supplier drlScoreDirectorFactorySupplier = (Supplier)scoreDirectorFactorySupplierMap.get((Object)ScoreDirectorType.DRL);
        this.assertOnlyOneScoreDirectorFactory(easyScoreDirectorFactorySupplier, constraintStreamScoreDirectorFactorySupplier, incrementalScoreDirectorFactorySupplier, drlScoreDirectorFactorySupplier);
        if (easyScoreDirectorFactorySupplier != null) {
            this.validateNoDroolsAlphaNetworkCompilation();
            this.validateNoGizmoKieBaseSupplier();
            return (AbstractScoreDirectorFactory)easyScoreDirectorFactorySupplier.get();
        }
        if (incrementalScoreDirectorFactorySupplier != null) {
            this.validateNoDroolsAlphaNetworkCompilation();
            this.validateNoGizmoKieBaseSupplier();
            return (AbstractScoreDirectorFactory)incrementalScoreDirectorFactorySupplier.get();
        }
        if (constraintStreamScoreDirectorFactorySupplier != null) {
            this.validateNoDroolsAlphaNetworkCompilation();
            this.validateNoGizmoKieBaseSupplier();
            return (AbstractScoreDirectorFactory)constraintStreamScoreDirectorFactorySupplier.get();
        }
        if (this.config.getConstraintProviderClass() != null) {
            throw new IllegalStateException("Constraint Streams requested via constraintProviderClass (" + this.config.getConstraintProviderClass() + ") but the supporting classes were not found on the classpath.\nMaybe include ai.timefold.solver:timefold-solver-constraint-streams-bavet dependency in your project?\nMaybe ensure your uberjar bundles META-INF/services from included JAR files?");
        }
        if (drlScoreDirectorFactorySupplier != null) {
            return (AbstractScoreDirectorFactory)drlScoreDirectorFactorySupplier.get();
        }
        if (!ConfigUtils.isEmptyCollection(this.config.getScoreDrlList()) || !ConfigUtils.isEmptyCollection(this.config.getScoreDrlFileList())) {
            throw new IllegalStateException("DRL constraints requested via scoreDrlList (" + this.config.getScoreDrlList() + ") or scoreDrlFileList (" + this.config.getScoreDrlFileList() + "), but the supporting classes were not found on the classpath.\nMaybe include ai.timefold.solver:timefold-solver-constraint-drl dependency in your project?\nMaybe ensure your uberjar bundles META-INF/services from included JAR files?");
        }
        throw new IllegalArgumentException("The scoreDirectorFactory lacks configuration for either constraintProviderClass, easyScoreCalculatorClass or incrementalScoreCalculatorClass.");
    }

    private void assertOnlyOneScoreDirectorFactory(Supplier<? extends ScoreDirectorFactory<Solution_>> easyScoreDirectorFactorySupplier, Supplier<? extends ScoreDirectorFactory<Solution_>> constraintStreamScoreDirectorFactorySupplier, Supplier<? extends ScoreDirectorFactory<Solution_>> incrementalScoreDirectorFactorySupplier, Supplier<? extends ScoreDirectorFactory<Solution_>> droolsScoreDirectorFactorySupplier) {
        if (Stream.of(easyScoreDirectorFactorySupplier, constraintStreamScoreDirectorFactorySupplier, incrementalScoreDirectorFactorySupplier, droolsScoreDirectorFactorySupplier).filter(Objects::nonNull).count() > 1L) {
            ArrayList<CallSite> scoreDirectorFactoryPropertyList = new ArrayList<CallSite>(4);
            if (easyScoreDirectorFactorySupplier != null) {
                scoreDirectorFactoryPropertyList.add((CallSite)((Object)("an easyScoreCalculatorClass (" + this.config.getEasyScoreCalculatorClass().getName() + ")")));
            }
            if (constraintStreamScoreDirectorFactorySupplier != null) {
                scoreDirectorFactoryPropertyList.add((CallSite)((Object)("a constraintProviderClass (" + this.config.getConstraintProviderClass().getName() + ")")));
            }
            if (incrementalScoreDirectorFactorySupplier != null) {
                scoreDirectorFactoryPropertyList.add((CallSite)((Object)("an incrementalScoreCalculatorClass (" + this.config.getIncrementalScoreCalculatorClass().getName() + ")")));
            }
            if (droolsScoreDirectorFactorySupplier != null) {
                String abbreviatedScoreDrlList = ConfigUtils.abbreviate(this.config.getScoreDrlList());
                String abbreviatedScoreDrlFileList = this.config.getScoreDrlFileList() == null ? "" : ConfigUtils.abbreviate(this.config.getScoreDrlFileList().stream().map(File::getName).collect(Collectors.toList()));
                scoreDirectorFactoryPropertyList.add((CallSite)((Object)("a scoreDrlList (" + abbreviatedScoreDrlList + ") or a scoreDrlFileList (" + abbreviatedScoreDrlFileList + ")")));
            }
            throw new IllegalArgumentException("The scoreDirectorFactory cannot have " + String.join((CharSequence)" and ", scoreDirectorFactoryPropertyList) + " together.");
        }
    }

    private void validateNoDroolsAlphaNetworkCompilation() {
        if (Objects.equals(this.config.getDroolsAlphaNetworkCompilationEnabled(), Boolean.TRUE)) {
            throw new IllegalStateException("If there is no scoreDrl (" + this.config.getScoreDrlList() + "), scoreDrlFile (" + this.config.getScoreDrlFileList() + ") or constraintProviderClass (" + this.config.getConstraintProviderClass() + ") with " + ConstraintStreamImplType.DROOLS + " impl type (" + this.config.getConstraintStreamImplType() + "), there can be no droolsAlphaNetworkCompilationEnabled (" + this.config.getDroolsAlphaNetworkCompilationEnabled() + ") either.");
        }
    }

    private void validateNoGizmoKieBaseSupplier() {
        if (this.config.getGizmoKieBaseSupplier() != null) {
            throw new IllegalStateException("If there is no constraintProviderClass (" + this.config.getConstraintProviderClass() + ") with " + ConstraintStreamImplType.DROOLS + " impl type (" + this.config.getConstraintStreamImplType() + "), there can be no gizmoKieBaseSupplier (" + this.config.getGizmoKieBaseSupplier() + ") either.");
        }
    }
}

