/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.definition;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.score.definition.ScoreDefinition;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;

public abstract class AbstractScoreDefinition<Score_ extends Score<Score_>>
implements ScoreDefinition<Score_> {
    private final String[] levelLabels;

    protected static int sanitize(int number) {
        return number == 0 ? 1 : number;
    }

    protected static long sanitize(long number) {
        return number == 0L ? 1L : number;
    }

    protected static BigDecimal sanitize(BigDecimal number) {
        return number.signum() == 0 ? BigDecimal.ONE : number;
    }

    protected static int divide(int dividend, int divisor) {
        return (int)Math.floor(AbstractScoreDefinition.divide((double)dividend, (double)divisor));
    }

    protected static long divide(long dividend, long divisor) {
        return (long)Math.floor(AbstractScoreDefinition.divide((double)dividend, (double)divisor));
    }

    protected static double divide(double dividend, double divisor) {
        return dividend / divisor;
    }

    protected static BigDecimal divide(BigDecimal dividend, BigDecimal divisor) {
        return dividend.divide(divisor, dividend.scale() - divisor.scale(), RoundingMode.FLOOR);
    }

    public AbstractScoreDefinition(String[] levelLabels) {
        this.levelLabels = levelLabels;
    }

    @Override
    public String getInitLabel() {
        return "init score";
    }

    @Override
    public int getLevelsSize() {
        return this.levelLabels.length;
    }

    @Override
    public String[] getLevelLabels() {
        return this.levelLabels;
    }

    @Override
    public String formatScore(Score_ score) {
        return score.toString();
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score score) {
        return Objects.equals(score.getClass(), this.getScoreClass());
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

