/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.score.constraint;

import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatch;
import ai.timefold.solver.core.api.score.constraint.ConstraintMatchTotal;
import ai.timefold.solver.core.api.score.stream.Constraint;
import ai.timefold.solver.core.api.score.stream.ConstraintJustification;
import ai.timefold.solver.core.api.score.stream.DefaultConstraintJustification;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class DefaultConstraintMatchTotal<Score_ extends Score<Score_>>
implements ConstraintMatchTotal<Score_>,
Comparable<DefaultConstraintMatchTotal<Score_>> {
    private final String constraintId;
    private final String constraintPackage;
    private final String constraintName;
    private final Score_ constraintWeight;
    private final Set<ConstraintMatch<Score_>> constraintMatchSet = new LinkedHashSet<ConstraintMatch<Score_>>();
    private Score_ score;

    public DefaultConstraintMatchTotal(String constraintPackage, String constraintName) {
        this(ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName), constraintPackage, constraintName);
    }

    private DefaultConstraintMatchTotal(String constraintId, String constraintPackage, String constraintName) {
        this.constraintPackage = Objects.requireNonNull(constraintPackage);
        this.constraintName = Objects.requireNonNull(constraintName);
        this.constraintId = Objects.requireNonNull(constraintId);
        this.constraintWeight = null;
    }

    public DefaultConstraintMatchTotal(Constraint constraint, Score_ constraintWeight) {
        this(constraint.getConstraintId(), constraint.getConstraintPackage(), constraint.getConstraintName(), constraintWeight);
    }

    public DefaultConstraintMatchTotal(String constraintPackage, String constraintName, Score_ constraintWeight) {
        this(ConstraintMatchTotal.composeConstraintId(constraintPackage, constraintName), constraintPackage, constraintName, constraintWeight);
    }

    private DefaultConstraintMatchTotal(String constraintId, String constraintPackage, String constraintName, Score_ constraintWeight) {
        this.constraintPackage = Objects.requireNonNull(constraintPackage);
        this.constraintName = Objects.requireNonNull(constraintName);
        this.constraintId = Objects.requireNonNull(constraintId);
        this.constraintWeight = (Score)Objects.requireNonNull(constraintWeight);
        this.score = constraintWeight.zero();
    }

    @Override
    public String getConstraintPackage() {
        return this.constraintPackage;
    }

    @Override
    public String getConstraintName() {
        return this.constraintName;
    }

    @Override
    public Score_ getConstraintWeight() {
        return this.constraintWeight;
    }

    @Override
    public Set<ConstraintMatch<Score_>> getConstraintMatchSet() {
        return this.constraintMatchSet;
    }

    @Override
    public Score_ getScore() {
        return this.score;
    }

    public ConstraintMatch<Score_> addConstraintMatch(List<Object> justifications, Score_ score) {
        return this.addConstraintMatch(DefaultConstraintJustification.of(score, justifications), justifications, score);
    }

    public ConstraintMatch<Score_> addConstraintMatch(ConstraintJustification justification, Collection<Object> indictedObjects, Score_ score) {
        ConstraintMatch<Score_> constraintMatch = new ConstraintMatch<Score_>(this.constraintId, this.constraintPackage, this.constraintName, justification, indictedObjects, score);
        this.addConstraintMatch(constraintMatch);
        return constraintMatch;
    }

    public void addConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        Score_ constraintMatchScore = constraintMatch.getScore();
        this.score = this.score == null ? constraintMatchScore : this.score.add(constraintMatchScore);
        this.constraintMatchSet.add(constraintMatch);
    }

    public void removeConstraintMatch(ConstraintMatch<Score_> constraintMatch) {
        this.score = this.score.subtract(constraintMatch.getScore());
        boolean removed = this.constraintMatchSet.remove(constraintMatch);
        if (!removed) {
            throw new IllegalStateException("The constraintMatchTotal (" + this + ") could not remove constraintMatch (" + constraintMatch + ") from its constraintMatchSet (" + this.constraintMatchSet + ").");
        }
    }

    @Override
    public String getConstraintId() {
        return this.constraintId;
    }

    @Override
    public int compareTo(DefaultConstraintMatchTotal<Score_> other) {
        return this.constraintId.compareTo(other.constraintId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DefaultConstraintMatchTotal) {
            DefaultConstraintMatchTotal other = (DefaultConstraintMatchTotal)o;
            return this.constraintPackage.equals(other.constraintPackage) && this.constraintName.equals(other.constraintName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.constraintPackage, this.constraintName);
    }

    public String toString() {
        return this.getConstraintId() + "=" + this.score;
    }
}

