/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase.custom;

import ai.timefold.solver.core.config.phase.custom.CustomPhaseConfig;
import ai.timefold.solver.core.config.solver.EnvironmentMode;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.phase.AbstractPhaseFactory;
import ai.timefold.solver.core.impl.phase.custom.CustomPhase;
import ai.timefold.solver.core.impl.phase.custom.CustomPhaseCommand;
import ai.timefold.solver.core.impl.phase.custom.DefaultCustomPhase;
import ai.timefold.solver.core.impl.solver.recaller.BestSolutionRecaller;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.util.ArrayList;

public class DefaultCustomPhaseFactory<Solution_>
extends AbstractPhaseFactory<Solution_, CustomPhaseConfig> {
    public DefaultCustomPhaseFactory(CustomPhaseConfig phaseConfig) {
        super(phaseConfig);
    }

    @Override
    public CustomPhase<Solution_> buildPhase(int phaseIndex, HeuristicConfigPolicy<Solution_> solverConfigPolicy, BestSolutionRecaller<Solution_> bestSolutionRecaller, Termination<Solution_> solverTermination) {
        HeuristicConfigPolicy<Solution_> phaseConfigPolicy = solverConfigPolicy.createPhaseConfigPolicy();
        if (ConfigUtils.isEmptyCollection(((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList()) && ConfigUtils.isEmptyCollection(((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList())) {
            throw new IllegalArgumentException("Configure at least 1 <customPhaseCommandClass> in the <customPhase> configuration.");
        }
        ArrayList customPhaseCommandList_ = new ArrayList(this.getCustomPhaseCommandListSize());
        if (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList() != null) {
            for (Class<? extends CustomPhaseCommand> customPhaseCommandClass : ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList()) {
                customPhaseCommandList_.add(this.createCustomPhaseCommand(customPhaseCommandClass));
            }
        }
        if (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList() != null) {
            customPhaseCommandList_.addAll(((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList());
        }
        DefaultCustomPhase.Builder<Solution_> builder = new DefaultCustomPhase.Builder<Solution_>(phaseIndex, solverConfigPolicy.getLogIndentation(), this.buildPhaseTermination(phaseConfigPolicy, solverTermination), customPhaseCommandList_);
        EnvironmentMode environmentMode = phaseConfigPolicy.getEnvironmentMode();
        if (environmentMode.isNonIntrusiveFullAsserted()) {
            builder.setAssertStepScoreFromScratch(true);
        }
        return builder.build();
    }

    private CustomPhaseCommand<Solution_> createCustomPhaseCommand(Class<? extends CustomPhaseCommand> customPhaseCommandClass) {
        CustomPhaseCommand customPhaseCommand = ConfigUtils.newInstance(this.phaseConfig, "customPhaseCommandClass", customPhaseCommandClass);
        ConfigUtils.applyCustomProperties(customPhaseCommand, "customPhaseCommandClass", ((CustomPhaseConfig)this.phaseConfig).getCustomProperties(), "customProperties");
        return customPhaseCommand;
    }

    private int getCustomPhaseCommandListSize() {
        return (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList() == null ? 0 : ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandClassList().size()) + (((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList() == null ? 0 : ((CustomPhaseConfig)this.phaseConfig).getCustomPhaseCommandList().size());
    }
}

