/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.phase.custom;

import ai.timefold.solver.core.impl.phase.AbstractPhase;
import ai.timefold.solver.core.impl.phase.custom.CustomPhase;
import ai.timefold.solver.core.impl.phase.custom.CustomPhaseCommand;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomPhaseScope;
import ai.timefold.solver.core.impl.phase.custom.scope.CustomStepScope;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import ai.timefold.solver.core.impl.solver.termination.Termination;
import java.util.List;

final class DefaultCustomPhase<Solution_>
extends AbstractPhase<Solution_>
implements CustomPhase<Solution_> {
    private final List<CustomPhaseCommand<Solution_>> customPhaseCommandList;

    private DefaultCustomPhase(Builder<Solution_> builder) {
        super(builder);
        this.customPhaseCommandList = builder.customPhaseCommandList;
    }

    @Override
    public String getPhaseTypeString() {
        return "Custom";
    }

    @Override
    public void solve(SolverScope<Solution_> solverScope) {
        CustomPhaseScope<Solution_> phaseScope = new CustomPhaseScope<Solution_>(solverScope);
        this.phaseStarted(phaseScope);
        for (CustomPhaseCommand<Solution_> customPhaseCommand : this.customPhaseCommandList) {
            solverScope.checkYielding();
            if (this.phaseTermination.isPhaseTerminated(phaseScope)) break;
            CustomStepScope<Solution_> stepScope = new CustomStepScope<Solution_>(phaseScope);
            this.stepStarted(stepScope);
            this.doStep(stepScope, customPhaseCommand);
            this.stepEnded(stepScope);
            phaseScope.setLastCompletedStepScope(stepScope);
        }
        this.phaseEnded(phaseScope);
    }

    private void doStep(CustomStepScope<Solution_> stepScope, CustomPhaseCommand<Solution_> customPhaseCommand) {
        InnerScoreDirector scoreDirector = stepScope.getScoreDirector();
        customPhaseCommand.changeWorkingSolution(scoreDirector);
        this.calculateWorkingStepScore(stepScope, customPhaseCommand);
        this.solver.getBestSolutionRecaller().processWorkingSolutionDuringStep(stepScope);
    }

    @Override
    public void stepEnded(CustomStepScope<Solution_> stepScope) {
        super.stepEnded(stepScope);
        AbstractPhaseScope phaseScope = stepScope.getPhaseScope();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{}    Custom step ({}), time spent ({}), score ({}), {} best score ({}).", new Object[]{this.logIndentation, stepScope.getStepIndex(), phaseScope.calculateSolverTimeMillisSpentUpToNow(), stepScope.getScore(), stepScope.getBestScoreImproved() ? "new" : "   ", phaseScope.getBestScore()});
        }
    }

    @Override
    public void phaseEnded(CustomPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        phaseScope.endingNow();
        this.logger.info("{}Custom phase ({}) ended: time spent ({}), best score ({}), score calculation speed ({}/sec), step total ({}).", new Object[]{this.logIndentation, this.phaseIndex, phaseScope.calculateSolverTimeMillisSpentUpToNow(), phaseScope.getBestScore(), phaseScope.getPhaseScoreCalculationSpeed(), phaseScope.getNextStepIndex()});
    }

    public static final class Builder<Solution_>
    extends AbstractPhase.Builder<Solution_> {
        private final List<CustomPhaseCommand<Solution_>> customPhaseCommandList;

        public Builder(int phaseIndex, String logIndentation, Termination<Solution_> phaseTermination, List<CustomPhaseCommand<Solution_>> customPhaseCommandList) {
            super(phaseIndex, logIndentation, phaseTermination);
            this.customPhaseCommandList = List.copyOf(customPhaseCommandList);
        }

        @Override
        public DefaultCustomPhase<Solution_> build() {
            return new DefaultCustomPhase(this);
        }
    }
}

