/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.localsearch.decider.acceptor.tabu.size;

import ai.timefold.solver.core.impl.localsearch.decider.acceptor.tabu.size.AbstractTabuSizeStrategy;
import ai.timefold.solver.core.impl.localsearch.scope.LocalSearchStepScope;

public class ValueRatioTabuSizeStrategy<Solution_>
extends AbstractTabuSizeStrategy<Solution_> {
    protected final double tabuRatio;

    public ValueRatioTabuSizeStrategy(double tabuRatio) {
        this.tabuRatio = tabuRatio;
        if (tabuRatio <= 0.0 || tabuRatio >= 1.0) {
            throw new IllegalArgumentException("The tabuRatio (" + tabuRatio + ") must be between 0.0 and 1.0.");
        }
    }

    @Override
    public int determineTabuSize(LocalSearchStepScope<Solution_> stepScope) {
        int valueCount = stepScope.getPhaseScope().getWorkingValueCount();
        int tabuSize = (int)Math.round((double)valueCount * this.tabuRatio);
        return this.protectTabuSizeCornerCases(valueCount, tabuSize);
    }
}

