/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.value.decorator;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.AbstractCachingValueSelector;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.Objects;

public final class SortingValueSelector<Solution_>
extends AbstractCachingValueSelector<Solution_>
implements EntityIndependentValueSelector<Solution_> {
    protected final SelectionSorter<Solution_, Object> sorter;

    public SortingValueSelector(EntityIndependentValueSelector<Solution_> childValueSelector, SelectionCacheType cacheType, SelectionSorter<Solution_, Object> sorter) {
        super(childValueSelector, cacheType);
        this.sorter = sorter;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        super.constructCache(solverScope);
        this.sorter.sort(solverScope.getScoreDirector(), this.cachedValueList);
        this.logger.trace("    Sorted cachedValueList: size ({}), valueSelector ({}).", (Object)this.cachedValueList.size(), (Object)this);
    }

    @Override
    public boolean isNeverEnding() {
        return false;
    }

    @Override
    public Iterator<Object> iterator(Object entity) {
        return this.iterator();
    }

    @Override
    public Iterator<Object> iterator() {
        return this.cachedValueList.iterator();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        SortingValueSelector that = (SortingValueSelector)other;
        return Objects.equals(this.sorter, that.sorter);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sorter);
    }

    public String toString() {
        return "Sorting(" + this.childValueSelector + ")";
    }
}

