/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableSupply;
import ai.timefold.solver.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.move.NoChangeMove;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.EntityOrderInfo;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptCycle;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.KOptUtils;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.kopt.TwoOptListMove;
import ai.timefold.solver.core.impl.heuristic.selector.value.EntityIndependentValueSelector;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;

final class KOptListMoveIterator<Solution_, Node_>
extends UpcomingSelectionIterator<Move<Solution_>> {
    private final Random workingRandom;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final SingletonInverseVariableSupply inverseVariableSupply;
    private final IndexVariableSupply indexVariableSupply;
    private final EntityIndependentValueSelector<Node_> originSelector;
    private final EntityIndependentValueSelector<Node_> valueSelector;
    private final int minK;
    private final int[] pickedKDistribution;
    private final int pickedKDistributionSum;
    private final int maxCyclesPatchedInInfeasibleMove;

    public KOptListMoveIterator(Random workingRandom, ListVariableDescriptor<Solution_> listVariableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, IndexVariableSupply indexVariableSupply, EntityIndependentValueSelector<Node_> originSelector, EntityIndependentValueSelector<Node_> valueSelector, int minK, int maxK, int[] pickedKDistribution) {
        this.workingRandom = workingRandom;
        this.listVariableDescriptor = listVariableDescriptor;
        this.inverseVariableSupply = inverseVariableSupply;
        this.indexVariableSupply = indexVariableSupply;
        this.originSelector = originSelector;
        this.valueSelector = valueSelector;
        this.minK = minK;
        this.pickedKDistribution = pickedKDistribution;
        int tmpPickedKDistributionSum = 0;
        for (int relativeDistributionAmount : pickedKDistribution) {
            tmpPickedKDistributionSum += relativeDistributionAmount;
        }
        this.pickedKDistributionSum = tmpPickedKDistributionSum;
        this.maxCyclesPatchedInInfeasibleMove = maxK;
    }

    @Override
    protected Move<Solution_> createUpcomingSelection() {
        int locationInDistribution = this.workingRandom.nextInt(this.pickedKDistributionSum);
        int indexInDistribution = 0;
        while (locationInDistribution >= this.pickedKDistribution[indexInDistribution]) {
            locationInDistribution -= this.pickedKDistribution[indexInDistribution];
            ++indexInDistribution;
        }
        int k = this.minK + indexInDistribution;
        if (k == 2) {
            return this.pickTwoOptMove();
        }
        KOptDescriptor<Node_> descriptor = this.pickKOptMove(k);
        if (descriptor == null) {
            return new NoChangeMove();
        }
        return descriptor.getKOptListMove(this.listVariableDescriptor, this.indexVariableSupply, this.inverseVariableSupply);
    }

    private TwoOptListMove<Solution_> pickTwoOptMove() {
        Iterator originIterator = this.originSelector.iterator();
        Iterator valueIterator = this.valueSelector.iterator();
        Object firstValue = originIterator.next();
        Object secondValue = valueIterator.next();
        Object firstEntity = this.inverseVariableSupply.getInverseSingleton(firstValue);
        Object secondEntity = this.inverseVariableSupply.getInverseSingleton(secondValue);
        return new TwoOptListMove<Solution_>(this.listVariableDescriptor, firstEntity, secondEntity, this.indexVariableSupply.getIndex(firstValue), this.indexVariableSupply.getIndex(secondValue));
    }

    private Iterator<Node_> getValuesOnSelectedEntitiesIterator(Node_[] pickedValues) {
        EntityOrderInfo entityOrderInfo = new EntityOrderInfo(pickedValues, this.inverseVariableSupply, this.listVariableDescriptor);
        IntStream pickedEntityIndexStream = this.workingRandom.ints(0, entityOrderInfo.entities.length);
        return pickedEntityIndexStream.mapToObj(index -> {
            Object entity = entityOrderInfo.entities[index];
            List<Object> listVariable = this.listVariableDescriptor.getListVariable(entity);
            return listVariable.get(this.workingRandom.nextInt(listVariable.size()));
        }).iterator();
    }

    private KOptDescriptor<Node_> pickKOptMove(int k) {
        int remainingAttempts;
        Object[] pickedValues = new Object[2 * k + 1];
        Iterator originIterator = this.originSelector.iterator();
        pickedValues[1] = originIterator.next();
        for (remainingAttempts = 20; remainingAttempts > 0 && this.listVariableDescriptor.getListSize(this.inverseVariableSupply.getInverseSingleton(pickedValues[1])) < 2; --remainingAttempts) {
            pickedValues[1] = originIterator.next();
        }
        if (remainingAttempts == 0) {
            return null;
        }
        EntityOrderInfo entityOrderInfo = new EntityOrderInfo(pickedValues, this.inverseVariableSupply, this.listVariableDescriptor);
        Object object = pickedValues[2] = this.workingRandom.nextBoolean() ? this.getNodeSuccessor(entityOrderInfo, pickedValues[1]) : this.getNodePredecessor(entityOrderInfo, pickedValues[1]);
        if (this.isNodeEndpointOfList(pickedValues[1]) || this.isNodeEndpointOfList(pickedValues[2])) {
            return this.pickKOptMoveRec(this.getValuesOnSelectedEntitiesIterator(pickedValues), entityOrderInfo, pickedValues, 2, k, false);
        }
        return this.pickKOptMoveRec(this.valueSelector.iterator(), entityOrderInfo, pickedValues, 2, k, true);
    }

    private KOptDescriptor<Node_> pickKOptMoveRec(Iterator<Node_> valueIterator, EntityOrderInfo entityOrderInfo, Node_[] pickedValues, int pickedSoFar, int k, boolean canSelectNewEntities) {
        Node_ previousRemovedEdgeEndpoint = pickedValues[2 * pickedSoFar - 2];
        int remainingAttempts = (k - pickedSoFar + 3) * 2;
        while (remainingAttempts > 0) {
            KOptDescriptor<Node_> descriptor;
            Node_ nextRemovedEdgePoint = valueIterator.next();
            EntityOrderInfo newEntityOrderInfo = entityOrderInfo.withNewNode(nextRemovedEdgePoint, this.listVariableDescriptor, this.inverseVariableSupply);
            while (nextRemovedEdgePoint == this.getNodePredecessor(newEntityOrderInfo, previousRemovedEdgeEndpoint) || nextRemovedEdgePoint == this.getNodeSuccessor(newEntityOrderInfo, previousRemovedEdgeEndpoint) || this.isEdgeAlreadyAdded(pickedValues, previousRemovedEdgeEndpoint, nextRemovedEdgePoint, pickedSoFar - 2) || this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2) && this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2)) {
                if (remainingAttempts == 0) {
                    return null;
                }
                nextRemovedEdgePoint = valueIterator.next();
                newEntityOrderInfo = entityOrderInfo.withNewNode(nextRemovedEdgePoint, this.listVariableDescriptor, this.inverseVariableSupply);
                --remainingAttempts;
            }
            --remainingAttempts;
            pickedValues[2 * pickedSoFar - 1] = nextRemovedEdgePoint;
            Node_ nextRemovedEdgeOppositePoint = this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2) ? this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint) : (this.isEdgeAlreadyDeleted(pickedValues, nextRemovedEdgePoint, this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint), pickedSoFar - 2) ? this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint) : (this.workingRandom.nextBoolean() ? this.getNodeSuccessor(newEntityOrderInfo, nextRemovedEdgePoint) : this.getNodePredecessor(newEntityOrderInfo, nextRemovedEdgePoint)));
            pickedValues[2 * pickedSoFar] = nextRemovedEdgeOppositePoint;
            if (canSelectNewEntities && this.isNodeEndpointOfList(nextRemovedEdgePoint) || this.isNodeEndpointOfList(nextRemovedEdgeOppositePoint)) {
                valueIterator = this.getValuesOnSelectedEntitiesIterator(pickedValues);
                canSelectNewEntities = false;
            }
            if (pickedSoFar < k) {
                descriptor = this.pickKOptMoveRec(valueIterator, newEntityOrderInfo, pickedValues, pickedSoFar + 1, k, canSelectNewEntities);
                if (descriptor == null || !descriptor.isFeasible()) continue;
                return descriptor;
            }
            descriptor = new KOptDescriptor<Node_>(pickedValues, KOptUtils.getMultiEntitySuccessorFunction(pickedValues, this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply), KOptUtils.getMultiEntityBetweenPredicate(pickedValues, this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply));
            if (descriptor.isFeasible()) {
                return descriptor;
            }
            if (!(descriptor = this.patchCycles(descriptor, newEntityOrderInfo, pickedValues, pickedSoFar)).isFeasible()) continue;
            return descriptor;
        }
        return null;
    }

    KOptDescriptor<Node_> patchCycles(KOptDescriptor<Node_> descriptor, EntityOrderInfo entityOrderInfo, Node_[] oldRemovedEdges, int k) {
        int[] removedEdgeIndexToTourOrder = descriptor.getRemovedEdgeIndexToTourOrder();
        Iterator<Node_> valueIterator = this.getValuesOnSelectedEntitiesIterator(oldRemovedEdges);
        KOptCycle cycleInfo = KOptUtils.getCyclesForPermutation(descriptor);
        int cycleCount = cycleInfo.cycleCount;
        int[] cycle = cycleInfo.indexToCycleIdentifier;
        if (cycleCount == 1 || cycleCount > this.maxCyclesPatchedInInfeasibleMove) {
            return descriptor;
        }
        int currentCycle = this.getShortestCycleIdentifier(entityOrderInfo, oldRemovedEdges, cycle, removedEdgeIndexToTourOrder, cycleCount, k);
        for (int i = 0; i < k; ++i) {
            if (cycle[removedEdgeIndexToTourOrder[2 * i]] != currentCycle) continue;
            Node_ sStart = oldRemovedEdges[removedEdgeIndexToTourOrder[2 * i]];
            Node_ sStop = oldRemovedEdges[removedEdgeIndexToTourOrder[2 * i + 1]];
            Node_ s1 = sStart;
            while (s1 != sStop) {
                Node_ s2;
                Node_[] removedEdges = Arrays.copyOf(oldRemovedEdges, oldRemovedEdges.length + 2);
                removedEdges[2 * k + 1] = s1;
                removedEdges[2 * k + 2] = s2 = this.getNodeSuccessor(entityOrderInfo, s1);
                int[] addedEdgeToOtherEndpoint = Arrays.copyOf(KOptDescriptor.computeInEdgesForSequentialMove(oldRemovedEdges), removedEdges.length + 2 + 2 * cycleCount);
                for (int newEdge = removedEdges.length; newEdge < addedEdgeToOtherEndpoint.length - 2; ++newEdge) {
                    addedEdgeToOtherEndpoint[newEdge] = newEdge + 2;
                }
                addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint.length - 1] = addedEdgeToOtherEndpoint.length - 3;
                addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint.length - 2] = addedEdgeToOtherEndpoint.length - 4;
                KOptDescriptor<Node_> newMove = this.patchCyclesRec(valueIterator, descriptor, entityOrderInfo, removedEdges, addedEdgeToOtherEndpoint, cycle, currentCycle, k, 2, cycleCount);
                if (newMove.isFeasible()) {
                    return newMove;
                }
                s1 = s2;
            }
        }
        return descriptor;
    }

    KOptDescriptor<Node_> patchCyclesRec(Iterator<Node_> valueIterator, KOptDescriptor<Node_> originalMove, EntityOrderInfo entityOrderInfo, Node_[] oldRemovedEdges, int[] addedEdgeToOtherEndpoint, int[] cycle, int currentCycle, int k, int patchedCycleCount, int cycleCount) {
        int NewCycle;
        Integer[] cycleSaved = new Integer[1 + 2 * k];
        Object[] removedEdges = Arrays.copyOf(oldRemovedEdges, oldRemovedEdges.length + 2);
        Node_ s1 = removedEdges[2 * k + 1];
        int i = 2 * (k + patchedCycleCount) - 2;
        Node_ s2 = removedEdges[i];
        addedEdgeToOtherEndpoint[i] = i + 1;
        addedEdgeToOtherEndpoint[addedEdgeToOtherEndpoint[i]] = i;
        for (i = 1; i <= 2 * k; ++i) {
            cycleSaved[i] = cycle[i];
        }
        Node_ s3 = valueIterator.next();
        int remainingAttempts = cycleCount * 2;
        while (s3 == this.getNodePredecessor(entityOrderInfo, s2) || s3 == this.getNodeSuccessor(entityOrderInfo, s2) || (NewCycle = this.findCycleIdentifierForNode(entityOrderInfo, s3, removedEdges, originalMove.getRemovedEdgeIndexToTourOrder(), cycle)) == currentCycle || this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodePredecessor(entityOrderInfo, s3), k) && this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodeSuccessor(entityOrderInfo, s3), k)) {
            if (remainingAttempts == 0) {
                return originalMove;
            }
            s3 = valueIterator.next();
            --remainingAttempts;
        }
        removedEdges[2 * (k + patchedCycleCount) - 1] = s3;
        Node_ s4 = this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodePredecessor(entityOrderInfo, s3), k) ? this.getNodeSuccessor(entityOrderInfo, s3) : (this.isEdgeAlreadyDeleted(removedEdges, s3, this.getNodeSuccessor(entityOrderInfo, s3), k) ? this.getNodePredecessor(entityOrderInfo, s3) : (this.workingRandom.nextBoolean() ? this.getNodeSuccessor(entityOrderInfo, s3) : this.getNodePredecessor(entityOrderInfo, s3)));
        removedEdges[2 * (k + patchedCycleCount)] = s4;
        if (cycleCount > 2) {
            for (i = 1; i <= 2 * k; ++i) {
                if (cycle[i] != NewCycle) continue;
                cycle[i] = currentCycle;
            }
            KOptDescriptor<Object> recursiveCall = this.patchCyclesRec(valueIterator, originalMove, entityOrderInfo, removedEdges, addedEdgeToOtherEndpoint, cycle, currentCycle, k, patchedCycleCount + 1, cycleCount - 1);
            if (recursiveCall.isFeasible()) {
                return recursiveCall;
            }
            for (i = 1; i <= 2 * k; ++i) {
                cycle[i] = cycleSaved[i];
            }
        } else if (s4 != s1) {
            int n = 2 * (k + patchedCycleCount);
            addedEdgeToOtherEndpoint[2 * k + 1] = n;
            addedEdgeToOtherEndpoint[n] = 2 * k + 1;
            return new KOptDescriptor<Object>(removedEdges, addedEdgeToOtherEndpoint, KOptUtils.getMultiEntitySuccessorFunction(removedEdges, this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply), KOptUtils.getMultiEntityBetweenPredicate(removedEdges, this.listVariableDescriptor, this.inverseVariableSupply, this.indexVariableSupply));
        }
        return originalMove;
    }

    int findCycleIdentifierForNode(EntityOrderInfo entityOrderInfo, Node_ value, Node_[] pickedValues, int[] permutation, int[] indexToCycle) {
        for (int i = 1; i < pickedValues.length; ++i) {
            if (!this.isMiddleNodeBetween(entityOrderInfo, pickedValues[permutation[i - 1]], value, pickedValues[permutation[i]])) continue;
            return indexToCycle[permutation[i]];
        }
        throw new IllegalStateException("Cannot find cycle the " + value + " belongs to");
    }

    int getShortestCycleIdentifier(EntityOrderInfo entityOrderInfo, Object[] removeEdgeEndpoints, int[] endpointIndexToCycle, int[] removeEdgeEndpointIndexToTourOrder, int cycleCount, int k) {
        int i;
        int minCycleIdentifier = 0;
        int minSize = Integer.MAX_VALUE;
        int[] size = new int[cycleCount + 1];
        for (i = 1; i <= cycleCount; ++i) {
            size[i] = 0;
        }
        removeEdgeEndpointIndexToTourOrder[0] = removeEdgeEndpointIndexToTourOrder[2 * k];
        for (i = 0; i < 2 * k; i += 2) {
            int n = endpointIndexToCycle[removeEdgeEndpointIndexToTourOrder[i]];
            size[n] = size[n] + this.getSegmentSize(entityOrderInfo, removeEdgeEndpoints[removeEdgeEndpointIndexToTourOrder[i]], removeEdgeEndpoints[removeEdgeEndpointIndexToTourOrder[i + 1]]);
        }
        for (i = 1; i <= cycleCount; ++i) {
            if (size[i] >= minSize) continue;
            minSize = size[i];
            minCycleIdentifier = i - 1;
        }
        return minCycleIdentifier;
    }

    private int getSegmentSize(EntityOrderInfo entityOrderInfo, Object from, Object to) {
        int endIndex;
        int startEntityIndex = entityOrderInfo.entityToEntityIndex.get(this.inverseVariableSupply.getInverseSingleton(from));
        int endEntityIndex = entityOrderInfo.entityToEntityIndex.get(this.inverseVariableSupply.getInverseSingleton(to));
        int startIndex = entityOrderInfo.offsets[startEntityIndex] + this.indexVariableSupply.getIndex(from);
        if (startIndex <= (endIndex = entityOrderInfo.offsets[endEntityIndex] + this.indexVariableSupply.getIndex(to))) {
            return endIndex - startIndex;
        }
        int totalRouteSize = entityOrderInfo.offsets[entityOrderInfo.offsets.length - 1] + this.listVariableDescriptor.getListSize(entityOrderInfo.entities[entityOrderInfo.entities.length - 1]);
        return totalRouteSize - startIndex + endIndex;
    }

    private boolean isEdgeAlreadyAdded(Object[] pickedValues, Object ta, Object tb, int k) {
        int i = 2 * k;
        while ((i -= 2) > 0) {
            if ((ta != pickedValues[i] || tb != pickedValues[i + 1]) && (ta != pickedValues[i + 1] || tb != pickedValues[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isEdgeAlreadyDeleted(Object[] pickedValues, Object ta, Object tb, int k) {
        int i = 2 * k + 2;
        while ((i -= 2) > 0) {
            if ((ta != pickedValues[i - 1] || tb != pickedValues[i]) && (ta != pickedValues[i] || tb != pickedValues[i - 1])) continue;
            return true;
        }
        return false;
    }

    private boolean isNodeEndpointOfList(Object node) {
        int index = this.indexVariableSupply.getIndex(node);
        int size = this.listVariableDescriptor.getListSize(this.inverseVariableSupply.getInverseSingleton(node));
        return index == 0 || index == size - 1;
    }

    private Node_ getNodeSuccessor(EntityOrderInfo entityOrderInfo, Node_ node) {
        return entityOrderInfo.successor(node, this.listVariableDescriptor, this.indexVariableSupply, this.inverseVariableSupply);
    }

    private Node_ getNodePredecessor(EntityOrderInfo entityOrderInfo, Node_ node) {
        return entityOrderInfo.predecessor(node, this.listVariableDescriptor, this.indexVariableSupply, this.inverseVariableSupply);
    }

    private boolean isMiddleNodeBetween(EntityOrderInfo entityOrderInfo, Node_ start, Node_ middle, Node_ end) {
        return entityOrderInfo.between(start, middle, end, this.indexVariableSupply, this.inverseVariableSupply);
    }
}

