/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic.list;

import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.AbstractRandomSwapIterator;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubList;
import ai.timefold.solver.core.impl.heuristic.selector.list.SubListSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.GenericMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.SubListSwapMove;
import java.util.Iterator;

public class RandomSubListSwapMoveSelector<Solution_>
extends GenericMoveSelector<Solution_> {
    private final SubListSelector<Solution_> leftSubListSelector;
    private final SubListSelector<Solution_> rightSubListSelector;
    private final ListVariableDescriptor<Solution_> listVariableDescriptor;
    private final boolean selectReversingMoveToo;

    public RandomSubListSwapMoveSelector(SubListSelector<Solution_> leftSubListSelector, SubListSelector<Solution_> rightSubListSelector, boolean selectReversingMoveToo) {
        this.leftSubListSelector = leftSubListSelector;
        this.rightSubListSelector = rightSubListSelector;
        this.listVariableDescriptor = leftSubListSelector.getVariableDescriptor();
        if (leftSubListSelector.getVariableDescriptor() != rightSubListSelector.getVariableDescriptor()) {
            throw new IllegalStateException("The selector (" + this + ") has a leftSubListSelector's variableDescriptor (" + leftSubListSelector.getVariableDescriptor() + ") which is not equal to the rightSubListSelector's variableDescriptor (" + rightSubListSelector.getVariableDescriptor() + ").");
        }
        this.selectReversingMoveToo = selectReversingMoveToo;
        this.phaseLifecycleSupport.addEventListener(leftSubListSelector);
        this.phaseLifecycleSupport.addEventListener(rightSubListSelector);
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new AbstractRandomSwapIterator<Solution_, Move<Solution_>, SubList>(this.leftSubListSelector, this.rightSubListSelector){

            @Override
            protected Move<Solution_> newSwapSelection(SubList leftSubSelection, SubList rightSubSelection) {
                boolean reversing = RandomSubListSwapMoveSelector.this.selectReversingMoveToo && RandomSubListSwapMoveSelector.this.workingRandom.nextBoolean();
                return new SubListSwapMove(RandomSubListSwapMoveSelector.this.listVariableDescriptor, leftSubSelection, rightSubSelection, reversing);
            }
        };
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return true;
    }

    @Override
    public long getSize() {
        long leftSubListCount = this.leftSubListSelector.getSize();
        long rightSubListCount = this.rightSubListSelector.getSize();
        return leftSubListCount * rightSubListCount * (long)(this.selectReversingMoveToo ? 2 : 1);
    }

    boolean isSelectReversingMoveToo() {
        return this.selectReversingMoveToo;
    }

    SubListSelector<Solution_> getLeftSubListSelector() {
        return this.leftSubListSelector;
    }

    SubListSelector<Solution_> getRightSubListSelector() {
        return this.rightSubListSelector;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.leftSubListSelector + ", " + this.rightSubListSelector + ")";
    }
}

