/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.list.DestinationSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.UnionMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.list.ListChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.value.ValueSelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.ChangeMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.list.ListChangeMoveSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelector;
import ai.timefold.solver.core.impl.heuristic.selector.value.ValueSelectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeMoveSelectorFactory<Solution_>
extends AbstractMoveSelectorFactory<Solution_, ChangeMoveSelectorConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeMoveSelectorFactory.class);

    public ChangeMoveSelectorFactory(ChangeMoveSelectorConfig moveSelectorConfig) {
        super(moveSelectorConfig);
    }

    @Override
    protected MoveSelector<Solution_> buildBaseMoveSelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ChangeMoveSelectorFactory.checkUnfolded("entitySelectorConfig", ((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig());
        ChangeMoveSelectorFactory.checkUnfolded("valueSelectorConfig", ((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig());
        SelectionOrder selectionOrder = SelectionOrder.fromRandomSelectionBoolean(randomSelection);
        EntitySelector entitySelector = EntitySelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig()).buildEntitySelector(configPolicy, minimumCacheType, selectionOrder);
        ValueSelector valueSelector = ValueSelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig()).buildValueSelector(configPolicy, entitySelector.getEntityDescriptor(), minimumCacheType, selectionOrder);
        return new ChangeMoveSelector(entitySelector, valueSelector, randomSelection);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntityDescriptor onlyEntityDescriptor = ((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig() == null ? null : EntitySelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig()).extractEntityDescriptor(configPolicy);
        Collection<Object> entityDescriptors = onlyEntityDescriptor != null ? Collections.singletonList(onlyEntityDescriptor) : configPolicy.getSolutionDescriptor().getGenuineEntityDescriptors();
        ArrayList<GenuineVariableDescriptor<Solution_>> variableDescriptorList = new ArrayList<GenuineVariableDescriptor<Solution_>>();
        for (EntityDescriptor entityDescriptor : entityDescriptors) {
            GenuineVariableDescriptor onlyVariableDescriptor;
            GenuineVariableDescriptor genuineVariableDescriptor = onlyVariableDescriptor = ((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig() == null ? null : ValueSelectorFactory.create(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig()).extractVariableDescriptor(configPolicy, entityDescriptor);
            if (onlyVariableDescriptor != null) {
                if (onlyEntityDescriptor != null) {
                    if (onlyVariableDescriptor.isListVariable()) {
                        return this.buildListChangeMoveSelectorConfig((ListVariableDescriptor)onlyVariableDescriptor, true);
                    }
                    return null;
                }
                variableDescriptorList.add(onlyVariableDescriptor);
                continue;
            }
            variableDescriptorList.addAll(entityDescriptor.getGenuineVariableDescriptorList());
        }
        return this.buildUnfoldedMoveSelectorConfig(variableDescriptorList);
    }

    @Override
    protected MoveSelectorConfig<?> buildUnfoldedMoveSelectorConfig(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList) {
        ArrayList<MoveSelectorConfig> moveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : variableDescriptorList) {
            MoveSelectorConfig childMoveSelectorConfig;
            if (variableDescriptor.isListVariable()) {
                childMoveSelectorConfig = this.buildListChangeMoveSelectorConfig((ListVariableDescriptor)variableDescriptor, false);
                moveSelectorConfigList.add(childMoveSelectorConfig);
                continue;
            }
            childMoveSelectorConfig = new ChangeMoveSelectorConfig();
            EntitySelectorConfig childEntitySelectorConfig = new EntitySelectorConfig(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig());
            if (childEntitySelectorConfig.getMimicSelectorRef() == null) {
                childEntitySelectorConfig.setEntityClass(variableDescriptor.getEntityDescriptor().getEntityClass());
            }
            ((ChangeMoveSelectorConfig)childMoveSelectorConfig).setEntitySelectorConfig(childEntitySelectorConfig);
            ValueSelectorConfig childValueSelectorConfig = new ValueSelectorConfig(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig());
            if (childValueSelectorConfig.getMimicSelectorRef() == null) {
                childValueSelectorConfig.setVariableName(variableDescriptor.getVariableName());
            }
            ((ChangeMoveSelectorConfig)childMoveSelectorConfig).setValueSelectorConfig(childValueSelectorConfig);
            moveSelectorConfigList.add(childMoveSelectorConfig);
        }
        MoveSelectorConfig unfoldedMoveSelectorConfig = moveSelectorConfigList.size() == 1 ? (MoveSelectorConfig)moveSelectorConfigList.get(0) : new UnionMoveSelectorConfig(moveSelectorConfigList);
        unfoldedMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        return unfoldedMoveSelectorConfig;
    }

    private ListChangeMoveSelectorConfig buildListChangeMoveSelectorConfig(ListVariableDescriptor<?> variableDescriptor, boolean inheritFoldedConfig) {
        LOGGER.warn("The changeMoveSelectorConfig ({}) is being used for a list variable. This was the only available option when the planning list variable was introduced. We are keeping this option through the 8.x release stream for backward compatibility reasons but it will be removed in the next major release.\nPlease update your solver config to use ListChangeMoveSelectorConfig now.", (Object)this.config);
        ListChangeMoveSelectorConfig listChangeMoveSelectorConfig = ListChangeMoveSelectorFactory.buildChildMoveSelectorConfig(variableDescriptor, ((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig(), new DestinationSelectorConfig().withEntitySelectorConfig(((ChangeMoveSelectorConfig)this.config).getEntitySelectorConfig()).withValueSelectorConfig(((ChangeMoveSelectorConfig)this.config).getValueSelectorConfig()));
        if (inheritFoldedConfig) {
            listChangeMoveSelectorConfig.inheritFolded((MoveSelectorConfig)this.config);
        }
        return listChangeMoveSelectorConfig;
    }
}

