/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.generic;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.move.AbstractMove;
import ai.timefold.solver.core.impl.score.director.InnerScoreDirector;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;

public class ChangeMove<Solution_>
extends AbstractMove<Solution_> {
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final Object entity;
    protected final Object toPlanningValue;

    public ChangeMove(GenuineVariableDescriptor<Solution_> variableDescriptor, Object entity, Object toPlanningValue) {
        this.variableDescriptor = variableDescriptor;
        this.entity = entity;
        this.toPlanningValue = toPlanningValue;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public Object getEntity() {
        return this.entity;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return !Objects.equals(oldValue, this.toPlanningValue);
    }

    @Override
    public ChangeMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return new ChangeMove<Solution_>(this.variableDescriptor, this.entity, oldValue);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        InnerScoreDirector innerScoreDirector = (InnerScoreDirector)scoreDirector;
        innerScoreDirector.changeVariableFacade(this.variableDescriptor, this.entity, this.toPlanningValue);
    }

    @Override
    public ChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new ChangeMove<Solution_>(this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.entity), destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return Collections.singletonList(this.entity);
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangeMove other = (ChangeMove)o;
        return Objects.equals(this.variableDescriptor, other.variableDescriptor) && Objects.equals(this.entity, other.entity) && Objects.equals(this.toPlanningValue, other.toPlanningValue);
    }

    public int hashCode() {
        return Objects.hash(this.variableDescriptor, this.entity, this.toPlanningValue);
    }

    public String toString() {
        Object oldValue = this.variableDescriptor.getValue(this.entity);
        return this.entity + " {" + oldValue + " -> " + this.toPlanningValue + "}";
    }
}

