/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.factory;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.factory.MoveListFactory;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.Iterator;
import java.util.List;

public class MoveListFactoryToMoveSelectorBridge<Solution_>
extends AbstractMoveSelector<Solution_>
implements SelectionCacheLifecycleListener<Solution_> {
    protected final MoveListFactory<Solution_> moveListFactory;
    protected final SelectionCacheType cacheType;
    protected final boolean randomSelection;
    protected List<Move<Solution_>> cachedMoveList = null;

    public MoveListFactoryToMoveSelectorBridge(MoveListFactory<Solution_> moveListFactory, SelectionCacheType cacheType, boolean randomSelection) {
        this.moveListFactory = moveListFactory;
        this.cacheType = cacheType;
        this.randomSelection = randomSelection;
        if (cacheType.isNotCached()) {
            throw new IllegalArgumentException("The selector (" + this + ") does not support the cacheType (" + cacheType + ").");
        }
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(cacheType, this));
    }

    @Override
    public SelectionCacheType getCacheType() {
        return this.cacheType;
    }

    @Override
    public boolean supportsPhaseAndSolverCaching() {
        return true;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        this.cachedMoveList = this.moveListFactory.createMoveList(solverScope.getScoreDirector().getWorkingSolution());
        this.logger.trace("    Created cachedMoveList: size ({}), moveSelector ({}).", (Object)this.cachedMoveList.size(), (Object)this);
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        this.cachedMoveList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.cachedMoveList.size();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        if (!this.randomSelection) {
            return this.cachedMoveList.iterator();
        }
        return new CachedListRandomIterator<Move<Solution_>>(this.cachedMoveList, this.workingRandom);
    }

    public String toString() {
        return "MoveListFactory(" + this.moveListFactory.getClass() + ")";
    }
}

