/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.move.decorator;

import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.heuristic.move.Move;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.move.AbstractMoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.phase.scope.AbstractPhaseScope;
import java.util.Iterator;

public class FilteringMoveSelector<Solution_>
extends AbstractMoveSelector<Solution_> {
    protected final MoveSelector<Solution_> childMoveSelector;
    protected final SelectionFilter<Solution_, Move<Solution_>> filter;
    protected final boolean bailOutEnabled;
    protected ScoreDirector<Solution_> scoreDirector = null;

    public FilteringMoveSelector(MoveSelector<Solution_> childMoveSelector, SelectionFilter<Solution_, Move<Solution_>> filter) {
        this.childMoveSelector = childMoveSelector;
        this.filter = filter;
        this.bailOutEnabled = childMoveSelector.isNeverEnding();
        this.phaseLifecycleSupport.addEventListener(childMoveSelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseStarted(phaseScope);
        this.scoreDirector = phaseScope.getScoreDirector();
    }

    @Override
    public void phaseEnded(AbstractPhaseScope<Solution_> phaseScope) {
        super.phaseEnded(phaseScope);
        this.scoreDirector = null;
    }

    @Override
    public boolean isCountable() {
        return this.childMoveSelector.isCountable();
    }

    @Override
    public boolean isNeverEnding() {
        return this.childMoveSelector.isNeverEnding();
    }

    @Override
    public long getSize() {
        return this.childMoveSelector.getSize();
    }

    @Override
    public Iterator<Move<Solution_>> iterator() {
        return new JustInTimeFilteringMoveIterator(this.childMoveSelector.iterator(), this.determineBailOutSize());
    }

    protected long determineBailOutSize() {
        if (!this.bailOutEnabled) {
            return -1L;
        }
        return this.childMoveSelector.getSize() * 10L;
    }

    protected boolean accept(ScoreDirector<Solution_> scoreDirector, Move<Solution_> move) {
        return this.filter == null || this.filter.accept(scoreDirector, move);
    }

    public String toString() {
        return "Filtering(" + this.childMoveSelector + ")";
    }

    private class JustInTimeFilteringMoveIterator
    extends UpcomingSelectionIterator<Move<Solution_>> {
        private final Iterator<Move<Solution_>> childMoveIterator;
        private final long bailOutSize;

        public JustInTimeFilteringMoveIterator(Iterator<Move<Solution_>> childMoveIterator, long bailOutSize) {
            this.childMoveIterator = childMoveIterator;
            this.bailOutSize = bailOutSize;
        }

        @Override
        protected Move<Solution_> createUpcomingSelection() {
            Move next;
            long attemptsBeforeBailOut = this.bailOutSize;
            do {
                if (!this.childMoveIterator.hasNext()) {
                    return (Move)this.noUpcomingSelection();
                }
                if (!FilteringMoveSelector.this.bailOutEnabled) continue;
                if (attemptsBeforeBailOut <= 0L) {
                    FilteringMoveSelector.this.logger.warn("Bailing out of neverEnding selector ({}) to avoid infinite loop.", (Object)FilteringMoveSelector.this);
                    return (Move)this.noUpcomingSelection();
                }
                --attemptsBeforeBailOut;
            } while (!FilteringMoveSelector.this.accept(FilteringMoveSelector.this.scoreDirector, next = this.childMoveIterator.next()));
            return next;
        }
    }
}

