/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity.pillar;

import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.entity.pillar.SubPillarConfigPolicy;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.SubPillarType;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelector;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleBridge;
import ai.timefold.solver.core.impl.heuristic.selector.common.SelectionCacheLifecycleListener;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.CachedListRandomIterator;
import ai.timefold.solver.core.impl.heuristic.selector.common.iterator.UpcomingSelectionIterator;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.pillar.PillarSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.generic.PillarDemand;
import ai.timefold.solver.core.impl.solver.scope.SolverScope;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public final class DefaultPillarSelector<Solution_>
extends AbstractSelector<Solution_>
implements PillarSelector<Solution_>,
SelectionCacheLifecycleListener<Solution_> {
    private static final SelectionCacheType CACHE_TYPE = SelectionCacheType.STEP;
    private final EntitySelector<Solution_> entitySelector;
    private final boolean randomSelection;
    private final SubPillarConfigPolicy subpillarConfigPolicy;
    private final PillarDemand<Solution_> pillarDemand;
    private List<List<Object>> cachedBasePillarList = null;

    public DefaultPillarSelector(EntitySelector<Solution_> entitySelector, List<GenuineVariableDescriptor<Solution_>> variableDescriptors, boolean randomSelection, SubPillarConfigPolicy subpillarConfigPolicy) {
        this.entitySelector = entitySelector;
        this.randomSelection = randomSelection;
        this.subpillarConfigPolicy = subpillarConfigPolicy;
        this.pillarDemand = new PillarDemand<Solution_>(entitySelector, variableDescriptors, subpillarConfigPolicy);
        Class<?> entityClass = entitySelector.getEntityDescriptor().getEntityClass();
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : variableDescriptors) {
            if (!entityClass.equals(variableDescriptor.getEntityDescriptor().getEntityClass())) {
                throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") with a entityClass (" + variableDescriptor.getEntityDescriptor().getEntityClass() + ") which is not equal to the entitySelector's entityClass (" + entityClass + ").");
            }
            if (!variableDescriptor.isChained()) continue;
            throw new IllegalStateException("The selector (" + this + ") has a variableDescriptor (" + variableDescriptor + ") which is chained (" + variableDescriptor.isChained() + ").");
        }
        if (entitySelector.isNeverEnding()) {
            throw new IllegalStateException("The selector (" + this + ") has an entitySelector (" + entitySelector + ") with neverEnding (" + entitySelector.isNeverEnding() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(entitySelector);
        this.phaseLifecycleSupport.addEventListener(new SelectionCacheLifecycleBridge(CACHE_TYPE, this));
        boolean subPillarEnabled = subpillarConfigPolicy.isSubPillarEnabled();
        if (!randomSelection && subPillarEnabled) {
            throw new IllegalStateException("The selector (" + this + ") with randomSelection  (" + randomSelection + ") does not support non random selection with sub pillars because the number of sub pillars scales exponentially.\nEither set subPillarType to " + SubPillarType.NONE + " or use JIT random selection.");
        }
    }

    @Override
    public EntityDescriptor<Solution_> getEntityDescriptor() {
        return this.entitySelector.getEntityDescriptor();
    }

    @Override
    public SelectionCacheType getCacheType() {
        return CACHE_TYPE;
    }

    PillarDemand<Solution_> getPillarDemand() {
        return this.pillarDemand;
    }

    @Override
    public void constructCache(SolverScope<Solution_> solverScope) {
        this.cachedBasePillarList = solverScope.getScoreDirector().getSupplyManager().demand(this.pillarDemand).read();
    }

    @Override
    public void disposeCache(SolverScope<Solution_> solverScope) {
        solverScope.getScoreDirector().getSupplyManager().cancel(this.pillarDemand);
        this.cachedBasePillarList = null;
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        if (!this.subpillarConfigPolicy.isSubPillarEnabled()) {
            return this.cachedBasePillarList.size();
        }
        throw new UnsupportedOperationException("The selector (" + this + ") with randomSelection  (" + this.randomSelection + ") and sub pillars does not support getSize() because the number of sub pillars scales exponentially.");
    }

    @Override
    public Iterator<List<Object>> iterator() {
        boolean subPillarEnabled = this.subpillarConfigPolicy.isSubPillarEnabled();
        if (!this.randomSelection) {
            if (!subPillarEnabled) {
                return this.cachedBasePillarList.iterator();
            }
            throw new IllegalStateException(this.getSubPillarExceptionMessage());
        }
        if (!subPillarEnabled) {
            return new CachedListRandomIterator<List<Object>>(this.cachedBasePillarList, this.workingRandom);
        }
        return new RandomSubPillarIterator();
    }

    private String getSubPillarExceptionMessage() {
        return "Impossible state because the constructors fails with randomSelection (" + this.randomSelection + ") and sub pillars.";
    }

    private String getListIteratorExceptionMessage() {
        return "The selector (" + this + ") does not support a ListIterator with randomSelection (" + this.randomSelection + ").";
    }

    @Override
    public ListIterator<List<Object>> listIterator() {
        boolean subPillarEnabled = this.subpillarConfigPolicy.isSubPillarEnabled();
        if (!this.randomSelection) {
            if (!subPillarEnabled) {
                return this.cachedBasePillarList.listIterator();
            }
            throw new IllegalStateException(this.getSubPillarExceptionMessage());
        }
        throw new IllegalStateException(this.getListIteratorExceptionMessage());
    }

    @Override
    public ListIterator<List<Object>> listIterator(int index) {
        boolean subPillarEnabled = this.subpillarConfigPolicy.isSubPillarEnabled();
        if (!this.randomSelection) {
            if (!subPillarEnabled) {
                return this.cachedBasePillarList.listIterator(index);
            }
            throw new IllegalStateException(this.getSubPillarExceptionMessage());
        }
        throw new IllegalStateException(this.getListIteratorExceptionMessage());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.entitySelector + ")";
    }

    private class RandomSubPillarIterator
    extends UpcomingSelectionIterator<List<Object>> {
        public RandomSubPillarIterator() {
            if (DefaultPillarSelector.this.cachedBasePillarList.isEmpty()) {
                this.upcomingSelection = this.noUpcomingSelection();
                this.upcomingCreated = true;
            }
        }

        @Override
        protected List<Object> createUpcomingSelection() {
            List<Object> basePillar = this.selectBasePillar();
            int basePillarSize = basePillar.size();
            if (basePillarSize == 1) {
                return basePillar;
            }
            int min = Math.min(DefaultPillarSelector.this.subpillarConfigPolicy.getMinimumSubPillarSize(), basePillarSize);
            int max = Math.min(DefaultPillarSelector.this.subpillarConfigPolicy.getMaximumSubPillarSize(), basePillarSize);
            int subPillarSize = min + DefaultPillarSelector.this.workingRandom.nextInt(max - min + 1);
            if (subPillarSize == basePillarSize) {
                return basePillar;
            }
            if (subPillarSize == 1) {
                int randomIndex = DefaultPillarSelector.this.workingRandom.nextInt(basePillarSize);
                Object randomElement = basePillar.get(randomIndex);
                return Collections.singletonList(randomElement);
            }
            Comparator<?> comparator = DefaultPillarSelector.this.subpillarConfigPolicy.getEntityComparator();
            if (comparator == null) {
                return this.selectRandom(basePillar, subPillarSize);
            }
            return this.selectSublist(basePillar, subPillarSize);
        }

        private List<Object> selectSublist(List<Object> basePillar, int subPillarSize) {
            int randomStartingIndex = DefaultPillarSelector.this.workingRandom.nextInt(basePillar.size() - subPillarSize);
            return basePillar.subList(randomStartingIndex, randomStartingIndex + subPillarSize);
        }

        private List<Object> selectRandom(List<Object> basePillar, int subPillarSize) {
            Object[] sandboxPillar = basePillar.toArray();
            ArrayList<Object> subPillar = new ArrayList<Object>(subPillarSize);
            for (int i = 0; i < subPillarSize; ++i) {
                int index = i + DefaultPillarSelector.this.workingRandom.nextInt(basePillar.size() - i);
                subPillar.add(sandboxPillar[index]);
                sandboxPillar[index] = sandboxPillar[i];
            }
            return subPillar;
        }

        private List<Object> selectBasePillar() {
            int baseListIndex = DefaultPillarSelector.this.workingRandom.nextInt(DefaultPillarSelector.this.cachedBasePillarList.size());
            return DefaultPillarSelector.this.cachedBasePillarList.get(baseListIndex);
        }
    }
}

