/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.entity;

import ai.timefold.solver.core.api.domain.solution.PlanningSolution;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.AbstractSelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionProbabilityWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandomFactory;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.FromSolutionEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.CachingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.FilteringEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.ProbabilityEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.SelectedCountLimitEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.ShufflingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.decorator.SortingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.EntityMimicRecorder;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicRecordingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.mimic.MimicReplayingEntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.nearby.NearEntityNearbyEntitySelector;
import ai.timefold.solver.core.impl.solver.ClassInstanceCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Stream;

public class EntitySelectorFactory<Solution_>
extends AbstractSelectorFactory<Solution_, EntitySelectorConfig> {
    public static <Solution_> EntitySelectorFactory<Solution_> create(EntitySelectorConfig entitySelectorConfig) {
        return new EntitySelectorFactory<Solution_>(entitySelectorConfig);
    }

    public EntitySelectorFactory(EntitySelectorConfig entitySelectorConfig) {
        super(entitySelectorConfig);
    }

    public EntityDescriptor<Solution_> extractEntityDescriptor(HeuristicConfigPolicy<Solution_> configPolicy) {
        if (((EntitySelectorConfig)this.config).getEntityClass() != null) {
            SolutionDescriptor<Solution_> solutionDescriptor = configPolicy.getSolutionDescriptor();
            EntityDescriptor<Solution_> entityDescriptor = solutionDescriptor.getEntityDescriptorStrict(((EntitySelectorConfig)this.config).getEntityClass());
            if (entityDescriptor == null) {
                throw new IllegalArgumentException("The selectorConfig (" + this.config + ") has an entityClass (" + ((EntitySelectorConfig)this.config).getEntityClass() + ") that is not a known planning entity.\nCheck your solver configuration. If that class (" + ((EntitySelectorConfig)this.config).getEntityClass().getSimpleName() + ") is not in the entityClassSet (" + solutionDescriptor.getEntityClassSet() + "), check your @" + PlanningSolution.class.getSimpleName() + " implementation's annotated methods too.");
            }
            return entityDescriptor;
        }
        if (((EntitySelectorConfig)this.config).getMimicSelectorRef() != null) {
            return configPolicy.getEntityMimicRecorder(((EntitySelectorConfig)this.config).getMimicSelectorRef()).getEntityDescriptor();
        }
        return null;
    }

    public EntitySelector<Solution_> buildEntitySelector(HeuristicConfigPolicy<Solution_> configPolicy, SelectionCacheType minimumCacheType, SelectionOrder inheritedSelectionOrder) {
        if (((EntitySelectorConfig)this.config).getMimicSelectorRef() != null) {
            return this.buildMimicReplaying(configPolicy);
        }
        EntityDescriptor<Solution_> entityDescriptor = this.deduceEntityDescriptor(configPolicy, ((EntitySelectorConfig)this.config).getEntityClass());
        SelectionCacheType resolvedCacheType = SelectionCacheType.resolve(((EntitySelectorConfig)this.config).getCacheType(), minimumCacheType);
        SelectionOrder resolvedSelectionOrder = SelectionOrder.resolve(((EntitySelectorConfig)this.config).getSelectionOrder(), inheritedSelectionOrder);
        if (((EntitySelectorConfig)this.config).getNearbySelectionConfig() != null) {
            ((EntitySelectorConfig)this.config).getNearbySelectionConfig().validateNearby(resolvedCacheType, resolvedSelectionOrder);
        }
        this.validateCacheTypeVersusSelectionOrder(resolvedCacheType, resolvedSelectionOrder);
        this.validateSorting(resolvedSelectionOrder);
        this.validateProbability(resolvedSelectionOrder);
        this.validateSelectedLimit(minimumCacheType);
        boolean baseRandomSelection = this.determineBaseRandomSelection(entityDescriptor, resolvedCacheType, resolvedSelectionOrder);
        SelectionCacheType baseSelectionCacheType = SelectionCacheType.max(minimumCacheType, resolvedCacheType);
        EntitySelector<Solution_> entitySelector = this.buildBaseEntitySelector(entityDescriptor, baseSelectionCacheType, baseRandomSelection);
        if (((EntitySelectorConfig)this.config).getNearbySelectionConfig() != null) {
            entitySelector = this.applyNearbySelection(configPolicy, ((EntitySelectorConfig)this.config).getNearbySelectionConfig(), minimumCacheType, resolvedSelectionOrder, entitySelector);
        }
        ClassInstanceCache instanceCache = configPolicy.getClassInstanceCache();
        entitySelector = this.applyFiltering(entitySelector, instanceCache);
        entitySelector = this.applySorting(resolvedCacheType, resolvedSelectionOrder, entitySelector, instanceCache);
        entitySelector = this.applyProbability(resolvedCacheType, resolvedSelectionOrder, entitySelector, instanceCache);
        entitySelector = this.applyShuffling(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyCaching(resolvedCacheType, resolvedSelectionOrder, entitySelector);
        entitySelector = this.applySelectedLimit(resolvedSelectionOrder, entitySelector);
        entitySelector = this.applyMimicRecording(configPolicy, entitySelector);
        return entitySelector;
    }

    protected EntitySelector<Solution_> buildMimicReplaying(HeuristicConfigPolicy<Solution_> configPolicy) {
        boolean anyConfigurationParameterDefined = Stream.of(new Object[]{((EntitySelectorConfig)this.config).getId(), ((EntitySelectorConfig)this.config).getEntityClass(), ((EntitySelectorConfig)this.config).getCacheType(), ((EntitySelectorConfig)this.config).getSelectionOrder(), ((EntitySelectorConfig)this.config).getNearbySelectionConfig(), ((EntitySelectorConfig)this.config).getFilterClass(), ((EntitySelectorConfig)this.config).getSorterManner(), ((EntitySelectorConfig)this.config).getSorterComparatorClass(), ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass(), ((EntitySelectorConfig)this.config).getSorterOrder(), ((EntitySelectorConfig)this.config).getSorterClass(), ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass(), ((EntitySelectorConfig)this.config).getSelectedCountLimit()}).anyMatch(Objects::nonNull);
        if (anyConfigurationParameterDefined) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with mimicSelectorRef (" + ((EntitySelectorConfig)this.config).getMimicSelectorRef() + ") has another property that is not null.");
        }
        EntityMimicRecorder<Solution_> entityMimicRecorder = configPolicy.getEntityMimicRecorder(((EntitySelectorConfig)this.config).getMimicSelectorRef());
        if (entityMimicRecorder == null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has a mimicSelectorRef (" + ((EntitySelectorConfig)this.config).getMimicSelectorRef() + ") for which no entitySelector with that id exists (in its solver phase).");
        }
        return new MimicReplayingEntitySelector<Solution_>(entityMimicRecorder);
    }

    protected boolean determineBaseRandomSelection(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        switch (resolvedSelectionOrder) {
            case ORIGINAL: {
                return false;
            }
            case SORTED: 
            case SHUFFLED: 
            case PROBABILISTIC: {
                return false;
            }
            case RANDOM: {
                return resolvedCacheType.isNotCached() || this.isBaseInherentlyCached() && !this.hasFiltering(entityDescriptor);
            }
        }
        throw new IllegalStateException("The selectionOrder (" + resolvedSelectionOrder + ") is not implemented.");
    }

    protected boolean isBaseInherentlyCached() {
        return true;
    }

    private EntitySelector<Solution_> buildBaseEntitySelector(EntityDescriptor<Solution_> entityDescriptor, SelectionCacheType minimumCacheType, boolean randomSelection) {
        if (minimumCacheType == SelectionCacheType.SOLVER) {
            throw new IllegalArgumentException("The minimumCacheType (" + minimumCacheType + ") is not yet supported. Please use " + SelectionCacheType.PHASE + " instead.");
        }
        return new FromSolutionEntitySelector<Solution_>(entityDescriptor, minimumCacheType, randomSelection);
    }

    private boolean hasFiltering(EntityDescriptor<Solution_> entityDescriptor) {
        return ((EntitySelectorConfig)this.config).getFilterClass() != null || entityDescriptor.hasEffectiveMovableEntitySelectionFilter();
    }

    private EntitySelector<Solution_> applyNearbySelection(HeuristicConfigPolicy<Solution_> configPolicy, NearbySelectionConfig nearbySelectionConfig, SelectionCacheType minimumCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        boolean randomSelection = resolvedSelectionOrder.toRandomSelectionBoolean();
        if (nearbySelectionConfig.getOriginEntitySelectorConfig() == null) {
            throw new IllegalArgumentException("The entitySelector (" + this.config + ")'s nearbySelectionConfig (" + nearbySelectionConfig + ") requires an originEntitySelector.");
        }
        EntitySelectorFactory<Solution_> entitySelectorFactory = EntitySelectorFactory.create(nearbySelectionConfig.getOriginEntitySelectorConfig());
        EntitySelector<Solution_> originEntitySelector = entitySelectorFactory.buildEntitySelector(configPolicy, minimumCacheType, resolvedSelectionOrder);
        NearbyDistanceMeter nearbyDistanceMeter = configPolicy.getClassInstanceCache().newInstance(nearbySelectionConfig, "nearbyDistanceMeterClass", nearbySelectionConfig.getNearbyDistanceMeterClass());
        NearbyRandom nearbyRandom = NearbyRandomFactory.create(nearbySelectionConfig).buildNearbyRandom(randomSelection);
        return new NearEntityNearbyEntitySelector<Solution_>(entitySelector, originEntitySelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    private EntitySelector<Solution_> applyFiltering(EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        EntityDescriptor<Solution_> entityDescriptor = entitySelector.getEntityDescriptor();
        if (this.hasFiltering(entityDescriptor)) {
            ArrayList filterList = new ArrayList(((EntitySelectorConfig)this.config).getFilterClass() == null ? 1 : 2);
            if (((EntitySelectorConfig)this.config).getFilterClass() != null) {
                SelectionFilter selectionFilter = instanceCache.newInstance(this.config, "filterClass", ((EntitySelectorConfig)this.config).getFilterClass());
                filterList.add(selectionFilter);
            }
            if (entityDescriptor.hasEffectiveMovableEntitySelectionFilter()) {
                filterList.add(entityDescriptor.getEffectiveMovableEntitySelectionFilter());
            }
            entitySelector = new FilteringEntitySelector<Solution_>(entitySelector, filterList);
        }
        return entitySelector;
    }

    protected void validateSorting(SelectionOrder resolvedSelectionOrder) {
        if ((((EntitySelectorConfig)this.config).getSorterManner() != null || ((EntitySelectorConfig)this.config).getSorterComparatorClass() != null || ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() != null || ((EntitySelectorConfig)this.config).getSorterOrder() != null || ((EntitySelectorConfig)this.config).getSorterClass() != null) && resolvedSelectionOrder != SelectionOrder.SORTED) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with sorterManner (" + ((EntitySelectorConfig)this.config).getSorterManner() + ") and sorterComparatorClass (" + ((EntitySelectorConfig)this.config).getSorterComparatorClass() + ") and sorterWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() + ") and sorterOrder (" + ((EntitySelectorConfig)this.config).getSorterOrder() + ") and sorterClass (" + ((EntitySelectorConfig)this.config).getSorterClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.SORTED + ".");
        }
        if (((EntitySelectorConfig)this.config).getSorterManner() != null && ((EntitySelectorConfig)this.config).getSorterComparatorClass() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has both a sorterManner (" + ((EntitySelectorConfig)this.config).getSorterManner() + ") and a sorterComparatorClass (" + ((EntitySelectorConfig)this.config).getSorterComparatorClass() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterManner() != null && ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has both a sorterManner (" + ((EntitySelectorConfig)this.config).getSorterManner() + ") and a sorterWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterManner() != null && ((EntitySelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has both a sorterManner (" + ((EntitySelectorConfig)this.config).getSorterManner() + ") and a sorterClass (" + ((EntitySelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterManner() != null && ((EntitySelectorConfig)this.config).getSorterOrder() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with sorterManner (" + ((EntitySelectorConfig)this.config).getSorterManner() + ") has a non-null sorterOrder (" + ((EntitySelectorConfig)this.config).getSorterOrder() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterComparatorClass() != null && ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has both a sorterComparatorClass (" + ((EntitySelectorConfig)this.config).getSorterComparatorClass() + ") and a sorterWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterComparatorClass() != null && ((EntitySelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has both a sorterComparatorClass (" + ((EntitySelectorConfig)this.config).getSorterComparatorClass() + ") and a sorterClass (" + ((EntitySelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() != null && ((EntitySelectorConfig)this.config).getSorterClass() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has both a sorterWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() + ") and a sorterClass (" + ((EntitySelectorConfig)this.config).getSorterClass() + ").");
        }
        if (((EntitySelectorConfig)this.config).getSorterClass() != null && ((EntitySelectorConfig)this.config).getSorterOrder() != null) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with sorterClass (" + ((EntitySelectorConfig)this.config).getSorterClass() + ") has a non-null sorterOrder (" + ((EntitySelectorConfig)this.config).getSorterOrder() + ").");
        }
    }

    protected EntitySelector<Solution_> applySorting(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.SORTED) {
            WeightFactorySelectionSorter sorter;
            if (((EntitySelectorConfig)this.config).getSorterManner() != null) {
                EntityDescriptor<Solution_> entityDescriptor = entitySelector.getEntityDescriptor();
                if (!EntitySelectorConfig.hasSorter(((EntitySelectorConfig)this.config).getSorterManner(), entityDescriptor)) {
                    return entitySelector;
                }
                sorter = EntitySelectorConfig.determineSorter(((EntitySelectorConfig)this.config).getSorterManner(), entityDescriptor);
            } else if (((EntitySelectorConfig)this.config).getSorterComparatorClass() != null) {
                Comparator sorterComparator = instanceCache.newInstance(this.config, "sorterComparatorClass", ((EntitySelectorConfig)this.config).getSorterComparatorClass());
                sorter = new ComparatorSelectionSorter(sorterComparator, SelectionSorterOrder.resolve(((EntitySelectorConfig)this.config).getSorterOrder()));
            } else if (((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() != null) {
                SelectionSorterWeightFactory sorterWeightFactory = instanceCache.newInstance(this.config, "sorterWeightFactoryClass", ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass());
                sorter = new WeightFactorySelectionSorter(sorterWeightFactory, SelectionSorterOrder.resolve(((EntitySelectorConfig)this.config).getSorterOrder()));
            } else if (((EntitySelectorConfig)this.config).getSorterClass() != null) {
                sorter = instanceCache.newInstance(this.config, "sorterClass", ((EntitySelectorConfig)this.config).getSorterClass());
            } else {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a sorterManner (" + ((EntitySelectorConfig)this.config).getSorterManner() + ") or a sorterComparatorClass (" + ((EntitySelectorConfig)this.config).getSorterComparatorClass() + ") or a sorterWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getSorterWeightFactoryClass() + ") or a sorterClass (" + ((EntitySelectorConfig)this.config).getSorterClass() + ").");
            }
            entitySelector = new SortingEntitySelector<Solution_>(entitySelector, resolvedCacheType, sorter);
        }
        return entitySelector;
    }

    protected void validateProbability(SelectionOrder resolvedSelectionOrder) {
        if (((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() != null && resolvedSelectionOrder != SelectionOrder.PROBABILISTIC) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with probabilityWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() + ") has a resolvedSelectionOrder (" + resolvedSelectionOrder + ") that is not " + SelectionOrder.PROBABILISTIC + ".");
        }
    }

    protected EntitySelector<Solution_> applyProbability(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector, ClassInstanceCache instanceCache) {
        if (resolvedSelectionOrder == SelectionOrder.PROBABILISTIC) {
            if (((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() == null) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with resolvedSelectionOrder (" + resolvedSelectionOrder + ") needs a probabilityWeightFactoryClass (" + ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass() + ").");
            }
            SelectionProbabilityWeightFactory probabilityWeightFactory = instanceCache.newInstance(this.config, "probabilityWeightFactoryClass", ((EntitySelectorConfig)this.config).getProbabilityWeightFactoryClass());
            entitySelector = new ProbabilityEntitySelector<Solution_>(entitySelector, resolvedCacheType, probabilityWeightFactory);
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyShuffling(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (resolvedSelectionOrder == SelectionOrder.SHUFFLED) {
            entitySelector = new ShufflingEntitySelector<Solution_>(entitySelector, resolvedCacheType);
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyCaching(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (resolvedCacheType.isCached() && resolvedCacheType.compareTo(entitySelector.getCacheType()) > 0) {
            entitySelector = new CachingEntitySelector<Solution_>(entitySelector, resolvedCacheType, resolvedSelectionOrder.toRandomSelectionBoolean());
        }
        return entitySelector;
    }

    private void validateSelectedLimit(SelectionCacheType minimumCacheType) {
        if (((EntitySelectorConfig)this.config).getSelectedCountLimit() != null && minimumCacheType.compareTo(SelectionCacheType.JUST_IN_TIME) > 0) {
            throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") with selectedCountLimit (" + ((EntitySelectorConfig)this.config).getSelectedCountLimit() + ") has a minimumCacheType (" + minimumCacheType + ") that is higher than " + SelectionCacheType.JUST_IN_TIME + ".");
        }
    }

    private EntitySelector<Solution_> applySelectedLimit(SelectionOrder resolvedSelectionOrder, EntitySelector<Solution_> entitySelector) {
        if (((EntitySelectorConfig)this.config).getSelectedCountLimit() != null) {
            entitySelector = new SelectedCountLimitEntitySelector<Solution_>(entitySelector, resolvedSelectionOrder.toRandomSelectionBoolean(), ((EntitySelectorConfig)this.config).getSelectedCountLimit());
        }
        return entitySelector;
    }

    private EntitySelector<Solution_> applyMimicRecording(HeuristicConfigPolicy<Solution_> configPolicy, EntitySelector<Solution_> entitySelector) {
        if (((EntitySelectorConfig)this.config).getId() != null) {
            if (((EntitySelectorConfig)this.config).getId().isEmpty()) {
                throw new IllegalArgumentException("The entitySelectorConfig (" + this.config + ") has an empty id (" + ((EntitySelectorConfig)this.config).getId() + ").");
            }
            MimicRecordingEntitySelector<Solution_> mimicRecordingEntitySelector = new MimicRecordingEntitySelector<Solution_>(entitySelector);
            configPolicy.addEntityMimicRecorder(((EntitySelectorConfig)this.config).getId(), mimicRecordingEntitySelector);
            entitySelector = mimicRecordingEntitySelector;
        }
        return entitySelector;
    }
}

