/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.nearby;

import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.nearby.NearbySelectionDistributionType;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.BetaDistributionNearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.BlockDistributionNearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.LinearDistributionNearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.ParabolicDistributionNearbyRandom;
import java.util.Objects;

public class NearbyRandomFactory {
    private final NearbySelectionConfig nearbySelectionConfig;

    public static NearbyRandomFactory create(NearbySelectionConfig nearbySelectionConfig) {
        return new NearbyRandomFactory(nearbySelectionConfig);
    }

    public NearbyRandomFactory(NearbySelectionConfig nearbySelectionConfig) {
        this.nearbySelectionConfig = nearbySelectionConfig;
    }

    public NearbyRandom buildNearbyRandom(boolean randomSelection) {
        boolean betaDistributionEnabled;
        boolean blockDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.BLOCK_DISTRIBUTION || this.nearbySelectionConfig.getBlockDistributionSizeMinimum() != null || this.nearbySelectionConfig.getBlockDistributionSizeMaximum() != null || this.nearbySelectionConfig.getBlockDistributionSizeRatio() != null || this.nearbySelectionConfig.getBlockDistributionUniformDistributionProbability() != null;
        boolean linearDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.LINEAR_DISTRIBUTION || this.nearbySelectionConfig.getLinearDistributionSizeMaximum() != null;
        boolean parabolicDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.PARABOLIC_DISTRIBUTION || this.nearbySelectionConfig.getParabolicDistributionSizeMaximum() != null;
        boolean bl = betaDistributionEnabled = this.nearbySelectionConfig.getNearbySelectionDistributionType() == NearbySelectionDistributionType.BETA_DISTRIBUTION || this.nearbySelectionConfig.getBetaDistributionAlpha() != null || this.nearbySelectionConfig.getBetaDistributionBeta() != null;
        if (!randomSelection) {
            if (blockDistributionEnabled || linearDistributionEnabled || parabolicDistributionEnabled || betaDistributionEnabled) {
                throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") with randomSelection (" + randomSelection + ") has distribution parameters.");
            }
            return null;
        }
        if (blockDistributionEnabled && linearDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both blockDistribution and linearDistribution parameters.");
        }
        if (blockDistributionEnabled && parabolicDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both blockDistribution and parabolicDistribution parameters.");
        }
        if (blockDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both blockDistribution and betaDistribution parameters.");
        }
        if (linearDistributionEnabled && parabolicDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both linearDistribution and parabolicDistribution parameters.");
        }
        if (linearDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both linearDistribution and betaDistribution parameters.");
        }
        if (parabolicDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this.nearbySelectionConfig + ") has both parabolicDistribution and betaDistribution parameters.");
        }
        if (blockDistributionEnabled) {
            int sizeMinimum = Objects.requireNonNullElse(this.nearbySelectionConfig.getBlockDistributionSizeMinimum(), 1);
            int sizeMaximum = Objects.requireNonNullElse(this.nearbySelectionConfig.getBlockDistributionSizeMaximum(), Integer.MAX_VALUE);
            double sizeRatio = Objects.requireNonNullElse(this.nearbySelectionConfig.getBlockDistributionSizeRatio(), 1.0);
            double uniformDistributionProbability = Objects.requireNonNullElse(this.nearbySelectionConfig.getBlockDistributionUniformDistributionProbability(), 0.0);
            return new BlockDistributionNearbyRandom(sizeMinimum, sizeMaximum, sizeRatio, uniformDistributionProbability);
        }
        if (linearDistributionEnabled) {
            int sizeMaximum = Objects.requireNonNullElse(this.nearbySelectionConfig.getLinearDistributionSizeMaximum(), Integer.MAX_VALUE);
            return new LinearDistributionNearbyRandom(sizeMaximum);
        }
        if (parabolicDistributionEnabled) {
            int sizeMaximum = Objects.requireNonNullElse(this.nearbySelectionConfig.getParabolicDistributionSizeMaximum(), Integer.MAX_VALUE);
            return new ParabolicDistributionNearbyRandom(sizeMaximum);
        }
        if (betaDistributionEnabled) {
            double alpha = Objects.requireNonNullElse(this.nearbySelectionConfig.getBetaDistributionAlpha(), 1.0);
            double beta = Objects.requireNonNullElse(this.nearbySelectionConfig.getBetaDistributionBeta(), 5.0);
            return new BetaDistributionNearbyRandom(alpha, beta);
        }
        return new LinearDistributionNearbyRandom(Integer.MAX_VALUE);
    }
}

