/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.heuristic.selector.common.nearby;

import ai.timefold.solver.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import java.util.Objects;
import java.util.Random;
import org.apache.commons.math3.distribution.BetaDistribution;

public final class BetaDistributionNearbyRandom
implements NearbyRandom {
    private final BetaDistribution betaDistribution;

    public BetaDistributionNearbyRandom(double betaDistributionAlpha, double betaDistributionBeta) {
        if (betaDistributionAlpha <= 0.0) {
            throw new IllegalArgumentException("The betaDistributionAlpha (" + betaDistributionAlpha + ") must be greater than 0.");
        }
        if (betaDistributionBeta <= 0.0) {
            throw new IllegalArgumentException("The betaDistributionBeta (" + betaDistributionBeta + ") must be greater than 0.");
        }
        this.betaDistribution = new BetaDistribution(betaDistributionAlpha, betaDistributionBeta);
    }

    @Override
    public int nextInt(Random random, int nearbySize) {
        double d = this.betaDistribution.inverseCumulativeProbability(random.nextDouble());
        int next = (int)(d * (double)nearbySize);
        if (next >= nearbySize) {
            next = nearbySize - 1;
        }
        return next;
    }

    @Override
    public int getOverallSizeMaximum() {
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        BetaDistributionNearbyRandom that = (BetaDistributionNearbyRandom)other;
        return Objects.equals(this.betaDistribution.getAlpha(), that.betaDistribution.getAlpha()) && Objects.equals(this.betaDistribution.getBeta(), that.betaDistribution.getBeta());
    }

    public int hashCode() {
        return Objects.hash(this.betaDistribution.getAlpha(), this.betaDistribution.getBeta());
    }
}

