/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.exhaustivesearch.node.comparator;

import ai.timefold.solver.core.impl.exhaustivesearch.node.ExhaustiveSearchNode;
import java.util.Comparator;

public class ScoreFirstNodeComparator
implements Comparator<ExhaustiveSearchNode> {
    public ScoreFirstNodeComparator(boolean scoreBounderEnabled) {
        if (!scoreBounderEnabled) {
            throw new IllegalArgumentException("This " + this.getClass().getSimpleName() + " only works if scoreBounderEnabled (" + scoreBounderEnabled + ") is true.");
        }
    }

    @Override
    public int compare(ExhaustiveSearchNode a, ExhaustiveSearchNode b) {
        long bParentBreadth;
        int bDepth;
        int scoreComparison = a.getScore().withInitScore(0).compareTo(b.getScore().withInitScore(0));
        if (scoreComparison < 0) {
            return -1;
        }
        if (scoreComparison > 0) {
            return 1;
        }
        int optimisticBoundComparison = a.getOptimisticBound().compareTo(b.getOptimisticBound());
        if (optimisticBoundComparison < 0) {
            return -1;
        }
        if (optimisticBoundComparison > 0) {
            return 1;
        }
        int aDepth = a.getDepth();
        if (aDepth < (bDepth = b.getDepth())) {
            return -1;
        }
        if (aDepth > bDepth) {
            return 1;
        }
        long aParentBreadth = a.getParentBreadth();
        if (aParentBreadth < (bParentBreadth = b.getParentBreadth())) {
            return -1;
        }
        if (aParentBreadth > bParentBreadth) {
            return 1;
        }
        return Long.compare(b.getBreadth(), a.getBreadth());
    }
}

