/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support;

import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class NotifiableRegistry<Solution_> {
    private final List<Notifiable> notifiableList = new ArrayList<Notifiable>();
    private final Map<EntityDescriptor<?>, Set<EntityNotifiable<Solution_>>> sourceEntityToNotifiableMap = new LinkedHashMap();
    private final Map<VariableDescriptor<?>, List<VariableListenerNotifiable<Solution_>>> sourceVariableToNotifiableMap = new LinkedHashMap();
    private final Map<VariableDescriptor<?>, List<ListVariableListenerNotifiable<Solution_>>> sourceListVariableToNotifiableMap = new LinkedHashMap();

    NotifiableRegistry(SolutionDescriptor<Solution_> solutionDescriptor) {
        for (EntityDescriptor<Solution_> entityDescriptor : solutionDescriptor.getEntityDescriptors()) {
            this.sourceEntityToNotifiableMap.put(entityDescriptor, new LinkedHashSet());
            for (VariableDescriptor<Solution_> variableDescriptor : entityDescriptor.getDeclaredVariableDescriptors()) {
                if (variableDescriptor.isGenuineListVariable()) {
                    this.sourceListVariableToNotifiableMap.put(variableDescriptor, new ArrayList());
                    continue;
                }
                this.sourceVariableToNotifiableMap.put(variableDescriptor, new ArrayList());
            }
        }
    }

    void registerNotifiable(VariableDescriptor<Solution_> source, EntityNotifiable<Solution_> notifiable) {
        this.registerNotifiable(Collections.singletonList(source), notifiable);
    }

    void registerNotifiable(Collection<VariableDescriptor<Solution_>> sources, EntityNotifiable<Solution_> notifiable) {
        for (VariableDescriptor<Solution_> source : sources) {
            if (source.isGenuineListVariable()) {
                this.sourceListVariableToNotifiableMap.get(source).add((ListVariableListenerNotifiable)notifiable);
            } else {
                this.sourceVariableToNotifiableMap.get(source).add((VariableListenerNotifiable)notifiable);
            }
            this.sourceEntityToNotifiableMap.get(source.getEntityDescriptor()).add(notifiable);
        }
        this.notifiableList.add(notifiable);
    }

    Iterable<Notifiable> getAll() {
        return this.notifiableList;
    }

    Collection<EntityNotifiable<Solution_>> get(EntityDescriptor<?> entityDescriptor) {
        return this.sourceEntityToNotifiableMap.get(entityDescriptor);
    }

    Collection<VariableListenerNotifiable<Solution_>> get(VariableDescriptor<?> variableDescriptor) {
        return this.sourceVariableToNotifiableMap.getOrDefault(variableDescriptor, Collections.emptyList());
    }

    Collection<ListVariableListenerNotifiable<Solution_>> get(ListVariableDescriptor<?> variableDescriptor) {
        return this.sourceListVariableToNotifiableMap.getOrDefault(variableDescriptor, Collections.emptyList());
    }
}

