/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.listener.support;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.domain.variable.ListVariableListener;
import ai.timefold.solver.core.api.domain.variable.VariableListener;
import ai.timefold.solver.core.api.score.director.ScoreDirector;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.EntityNotification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.ListVariableListenerNotifiable;
import ai.timefold.solver.core.impl.domain.variable.listener.support.Notification;
import ai.timefold.solver.core.impl.domain.variable.listener.support.VariableListenerNotifiable;
import ai.timefold.solver.core.impl.util.ListBasedScalingOrderedSet;
import java.util.ArrayDeque;
import java.util.Collection;

abstract class AbstractNotifiable<Solution_, T extends AbstractVariableListener<Solution_, Object>>
implements EntityNotifiable<Solution_> {
    private final ScoreDirector<Solution_> scoreDirector;
    private final T variableListener;
    private final Collection<Notification<Solution_, ? super T>> notificationQueue;
    private final int globalOrder;

    static <Solution_> EntityNotifiable<Solution_> buildNotifiable(ScoreDirector<Solution_> scoreDirector, AbstractVariableListener<Solution_, Object> variableListener, int globalOrder) {
        VariableListener basicVariableListener;
        if (variableListener instanceof ListVariableListener) {
            return new ListVariableListenerNotifiable<Solution_>(scoreDirector, (ListVariableListener)variableListener, new ArrayDeque(), globalOrder);
        }
        return new VariableListenerNotifiable<Solution_>(scoreDirector, basicVariableListener, (basicVariableListener = (VariableListener)variableListener).requiresUniqueEntityEvents() ? new ListBasedScalingOrderedSet() : new ArrayDeque(), globalOrder);
    }

    AbstractNotifiable(ScoreDirector<Solution_> scoreDirector, T variableListener, Collection<Notification<Solution_, ? super T>> notificationQueue, int globalOrder) {
        this.scoreDirector = scoreDirector;
        this.variableListener = variableListener;
        this.notificationQueue = notificationQueue;
        this.globalOrder = globalOrder;
    }

    @Override
    public void notifyBefore(EntityNotification<Solution_> notification) {
        if (this.notificationQueue.add(notification)) {
            notification.triggerBefore(this.variableListener, this.scoreDirector);
        }
    }

    protected boolean storeForLater(Notification<Solution_, T> notification) {
        return this.notificationQueue.add(notification);
    }

    protected void triggerBefore(Notification<Solution_, T> notification) {
        notification.triggerBefore(this.variableListener, this.scoreDirector);
    }

    @Override
    public void resetWorkingSolution() {
        this.variableListener.resetWorkingSolution(this.scoreDirector);
    }

    @Override
    public void closeVariableListener() {
        this.variableListener.close();
    }

    @Override
    public void triggerAllNotifications() {
        int notifiedCount = 0;
        for (Notification<Solution_, T> notification : this.notificationQueue) {
            notification.triggerAfter(this.variableListener, this.scoreDirector);
            ++notifiedCount;
        }
        if (notifiedCount != this.notificationQueue.size()) {
            throw new IllegalStateException("The variableListener (" + this.variableListener.getClass() + ") has been notified with notifiedCount (" + notifiedCount + ") but after being triggered, its notificationCount (" + this.notificationQueue.size() + ") is different.\nMaybe that variableListener (" + this.variableListener.getClass() + ") changed an upstream shadow variable (which is illegal).");
        }
        this.notificationQueue.clear();
    }

    public String toString() {
        return "(" + this.globalOrder + ") " + this.variableListener;
    }
}

