/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.index;

import ai.timefold.solver.core.api.domain.variable.AbstractVariableListener;
import ai.timefold.solver.core.api.domain.variable.IndexShadowVariable;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ListVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.ShadowVariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableDemand;
import ai.timefold.solver.core.impl.domain.variable.index.IndexVariableListener;
import ai.timefold.solver.core.impl.domain.variable.listener.VariableListenerWithSources;
import ai.timefold.solver.core.impl.domain.variable.supply.SupplyManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class IndexShadowVariableDescriptor<Solution_>
extends ShadowVariableDescriptor<Solution_> {
    protected ListVariableDescriptor<Solution_> sourceVariableDescriptor;

    public IndexShadowVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
        if (!variableMemberAccessor.getType().equals(Integer.class) && !variableMemberAccessor.getType().equals(Long.class)) {
            throw new IllegalStateException("The entityClass (" + entityDescriptor.getEntityClass() + ") has an @" + IndexShadowVariable.class.getSimpleName() + " annotated member (" + variableMemberAccessor + ") of type (" + variableMemberAccessor.getType() + ") which cannot represent an index in a list.\nThe @" + IndexShadowVariable.class.getSimpleName() + " annotated member type must be " + Integer.class + " or " + Long.class + ".");
        }
    }

    @Override
    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.linkShadowSources(descriptorPolicy);
    }

    private void linkShadowSources(DescriptorPolicy descriptorPolicy) {
        String sourceVariableName = this.variableMemberAccessor.getAnnotation(IndexShadowVariable.class).sourceVariableName();
        List entitiesWithSourceVariable = this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors().stream().filter(entityDescriptor -> entityDescriptor.hasVariableDescriptor(sourceVariableName)).collect(Collectors.toList());
        if (entitiesWithSourceVariable.isEmpty()) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has an @" + IndexShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a valid planning variable on any of the entity classes (" + this.entityDescriptor.getSolutionDescriptor().getEntityDescriptors() + ").");
        }
        if (entitiesWithSourceVariable.size() > 1) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has an @" + IndexShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a unique planning variable. A planning variable with the name (" + sourceVariableName + ") exists on multiple entity classes (" + entitiesWithSourceVariable + ").");
        }
        VariableDescriptor variableDescriptor = ((EntityDescriptor)entitiesWithSourceVariable.get(0)).getVariableDescriptor(sourceVariableName);
        if (variableDescriptor == null) {
            throw new IllegalStateException("Impossible state: variableDescriptor (" + variableDescriptor + ") is null but previous checks indicate that the entityClass (" + entitiesWithSourceVariable.get(0) + ") has a planning variable with sourceVariableName (" + sourceVariableName + ").");
        }
        if (!(variableDescriptor instanceof ListVariableDescriptor)) {
            throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has an @" + IndexShadowVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with sourceVariableName (" + sourceVariableName + ") which is not a @" + PlanningListVariable.class.getSimpleName() + ".");
        }
        this.sourceVariableDescriptor = (ListVariableDescriptor)variableDescriptor;
        this.sourceVariableDescriptor.registerSinkVariableDescriptor(this);
    }

    @Override
    public List<VariableDescriptor<Solution_>> getSourceVariableDescriptorList() {
        return Collections.singletonList(this.sourceVariableDescriptor);
    }

    @Override
    public Collection<Class<? extends AbstractVariableListener>> getVariableListenerClasses() {
        return Collections.singleton(IndexVariableListener.class);
    }

    @Override
    public IndexVariableDemand<Solution_> getProvidedDemand() {
        return new IndexVariableDemand<Solution_>(this.sourceVariableDescriptor);
    }

    @Override
    public Iterable<VariableListenerWithSources<Solution_>> buildVariableListeners(SupplyManager supplyManager) {
        return new VariableListenerWithSources<Solution_>(new IndexVariableListener<Solution_>(this, this.sourceVariableDescriptor), this.sourceVariableDescriptor).toCollection();
    }

    @Override
    public Integer getValue(Object entity) {
        return (Integer)super.getValue(entity);
    }
}

