/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.variable.descriptor;

import ai.timefold.solver.core.api.domain.valuerange.CountableValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRange;
import ai.timefold.solver.core.api.domain.valuerange.ValueRangeProvider;
import ai.timefold.solver.core.api.domain.variable.PlanningVariable;
import ai.timefold.solver.core.config.heuristic.selector.common.decorator.SelectionSorterOrder;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.domain.common.accessor.MemberAccessor;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.policy.DescriptorPolicy;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.CompositeValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.FromEntityPropertyValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.FromSolutionPropertyValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.VariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.ComparatorSelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionFilter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.SelectionSorterWeightFactory;
import ai.timefold.solver.core.impl.heuristic.selector.common.decorator.WeightFactorySelectionSorter;
import ai.timefold.solver.core.impl.heuristic.selector.value.decorator.MovableChainedTrailingValueFilter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Stream;

public abstract class GenuineVariableDescriptor<Solution_>
extends VariableDescriptor<Solution_> {
    private ValueRangeDescriptor<Solution_> valueRangeDescriptor;
    private SelectionFilter<Solution_, Object> movableChainedTrailingValueFilter;
    private SelectionSorter<Solution_, Object> increasingStrengthSorter;
    private SelectionSorter<Solution_, Object> decreasingStrengthSorter;

    public GenuineVariableDescriptor(EntityDescriptor<Solution_> entityDescriptor, MemberAccessor variableMemberAccessor) {
        super(entityDescriptor, variableMemberAccessor);
    }

    public void processAnnotations(DescriptorPolicy descriptorPolicy) {
        this.processPropertyAnnotations(descriptorPolicy);
    }

    protected abstract void processPropertyAnnotations(DescriptorPolicy var1);

    protected void processValueRangeRefs(DescriptorPolicy descriptorPolicy, String[] valueRangeProviderRefs) {
        MemberAccessor[] valueRangeProviderMemberAccessors;
        if (valueRangeProviderRefs == null || valueRangeProviderRefs.length == 0) {
            valueRangeProviderMemberAccessors = this.findAnonymousValueRangeMemberAccessors(descriptorPolicy);
            if (valueRangeProviderMemberAccessors.length == 0) {
                throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") that has no valueRangeProviderRefs (" + Arrays.toString(valueRangeProviderRefs) + ") and no matching anonymous value range providers were found.");
            }
        } else {
            valueRangeProviderMemberAccessors = (MemberAccessor[])Arrays.stream(valueRangeProviderRefs).map(ref -> this.findValueRangeMemberAccessor(descriptorPolicy, (String)ref)).toArray(MemberAccessor[]::new);
        }
        ArrayList valueRangeDescriptorList = new ArrayList(valueRangeProviderMemberAccessors.length);
        boolean addNullInValueRange = this.isNullable() && valueRangeProviderMemberAccessors.length == 1;
        for (MemberAccessor valueRangeProviderMemberAccessor : valueRangeProviderMemberAccessors) {
            valueRangeDescriptorList.add(this.buildValueRangeDescriptor(descriptorPolicy, valueRangeProviderMemberAccessor, addNullInValueRange));
        }
        this.valueRangeDescriptor = valueRangeDescriptorList.size() == 1 ? (ValueRangeDescriptor)valueRangeDescriptorList.get(0) : new CompositeValueRangeDescriptor(this, this.isNullable(), valueRangeDescriptorList);
    }

    private MemberAccessor[] findAnonymousValueRangeMemberAccessors(DescriptorPolicy descriptorPolicy) {
        boolean supportsValueRangeProviderFromEntity = !this.isListVariable();
        Stream applicableValueRangeProviderAccessors = supportsValueRangeProviderFromEntity ? Stream.concat(descriptorPolicy.getAnonymousFromEntityValueRangeProviderSet().stream(), descriptorPolicy.getAnonymousFromSolutionValueRangeProviderSet().stream()) : descriptorPolicy.getAnonymousFromSolutionValueRangeProviderSet().stream();
        return (MemberAccessor[])applicableValueRangeProviderAccessors.filter(valueRangeProviderAccessor -> {
            Class variableType = this.isListVariable() ? (Class)((ParameterizedType)this.variableMemberAccessor.getGenericType()).getActualTypeArguments()[0] : this.variableMemberAccessor.getType();
            Type valueRangeType = valueRangeProviderAccessor.getGenericType();
            if (valueRangeType instanceof ParameterizedType) {
                ParameterizedType parameterizedValueRangeType = (ParameterizedType)valueRangeType;
                Class rawType = (Class)parameterizedValueRangeType.getRawType();
                if (!ValueRange.class.isAssignableFrom(rawType) && !Collection.class.isAssignableFrom(rawType)) {
                    return false;
                }
                Type[] generics = parameterizedValueRangeType.getActualTypeArguments();
                if (generics.length != 1) {
                    return false;
                }
                Class valueRangeGenericType = (Class)generics[0];
                return variableType.isAssignableFrom(valueRangeGenericType);
            }
            Class clz = (Class)valueRangeType;
            if (clz.isArray()) {
                Class<?> componentType = clz.getComponentType();
                return variableType.isAssignableFrom(componentType);
            }
            return false;
        }).toArray(MemberAccessor[]::new);
    }

    private MemberAccessor findValueRangeMemberAccessor(DescriptorPolicy descriptorPolicy, String valueRangeProviderRef) {
        if (descriptorPolicy.hasFromSolutionValueRangeProvider(valueRangeProviderRef)) {
            return descriptorPolicy.getFromSolutionValueRangeProvider(valueRangeProviderRef);
        }
        if (descriptorPolicy.hasFromEntityValueRangeProvider(valueRangeProviderRef)) {
            return descriptorPolicy.getFromEntityValueRangeProvider(valueRangeProviderRef);
        }
        Collection<String> providerIds = descriptorPolicy.getValueRangeProviderIds();
        throw new IllegalArgumentException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") has a @" + PlanningVariable.class.getSimpleName() + " annotated property (" + this.variableMemberAccessor.getName() + ") with a valueRangeProviderRef (" + valueRangeProviderRef + ") that does not exist in a @" + ValueRangeProvider.class.getSimpleName() + " on the solution class (" + this.entityDescriptor.getSolutionDescriptor().getSolutionClass().getSimpleName() + ") or on that entityClass.\nThe valueRangeProviderRef (" + valueRangeProviderRef + ") does not appear in the valueRangeProvideIds (" + providerIds + ")." + (String)(!providerIds.isEmpty() ? "" : "\nMaybe a @" + ValueRangeProvider.class.getSimpleName() + " annotation is missing on a method in the solution class (" + this.entityDescriptor.getSolutionDescriptor().getSolutionClass().getSimpleName() + ")."));
    }

    private ValueRangeDescriptor<Solution_> buildValueRangeDescriptor(DescriptorPolicy descriptorPolicy, MemberAccessor valueRangeProviderMemberAccessor, boolean addNullInValueRange) {
        if (descriptorPolicy.isFromSolutionValueRangeProvider(valueRangeProviderMemberAccessor)) {
            return new FromSolutionPropertyValueRangeDescriptor(this, addNullInValueRange, valueRangeProviderMemberAccessor);
        }
        if (descriptorPolicy.isFromEntityValueRangeProvider(valueRangeProviderMemberAccessor)) {
            return new FromEntityPropertyValueRangeDescriptor(this, addNullInValueRange, valueRangeProviderMemberAccessor);
        }
        throw new IllegalStateException("Impossible state: member accessor (" + valueRangeProviderMemberAccessor + ") is not a value range provider.");
    }

    protected void processStrength(Class<? extends Comparator> strengthComparatorClass, Class<? extends SelectionSorterWeightFactory> strengthWeightFactoryClass) {
        if (strengthComparatorClass == PlanningVariable.NullStrengthComparator.class) {
            strengthComparatorClass = null;
        }
        if (strengthWeightFactoryClass == PlanningVariable.NullStrengthWeightFactory.class) {
            strengthWeightFactoryClass = null;
        }
        if (strengthComparatorClass != null && strengthWeightFactoryClass != null) {
            throw new IllegalStateException("The entityClass (" + this.entityDescriptor.getEntityClass() + ") property (" + this.variableMemberAccessor.getName() + ") cannot have a strengthComparatorClass (" + strengthComparatorClass.getName() + ") and a strengthWeightFactoryClass (" + strengthWeightFactoryClass.getName() + ") at the same time.");
        }
        if (strengthComparatorClass != null) {
            Comparator strengthComparator = ConfigUtils.newInstance(this::toString, "strengthComparatorClass", strengthComparatorClass);
            this.increasingStrengthSorter = new ComparatorSelectionSorter<Solution_, Object>(strengthComparator, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new ComparatorSelectionSorter<Solution_, Object>(strengthComparator, SelectionSorterOrder.DESCENDING);
        }
        if (strengthWeightFactoryClass != null) {
            SelectionSorterWeightFactory strengthWeightFactory = ConfigUtils.newInstance(this::toString, "strengthWeightFactoryClass", strengthWeightFactoryClass);
            this.increasingStrengthSorter = new WeightFactorySelectionSorter<Solution_, Object>(strengthWeightFactory, SelectionSorterOrder.ASCENDING);
            this.decreasingStrengthSorter = new WeightFactorySelectionSorter<Solution_, Object>(strengthWeightFactory, SelectionSorterOrder.DESCENDING);
        }
    }

    @Override
    public void linkVariableDescriptors(DescriptorPolicy descriptorPolicy) {
        this.movableChainedTrailingValueFilter = this.isChained() && this.entityDescriptor.hasEffectiveMovableEntitySelectionFilter() ? new MovableChainedTrailingValueFilter(this) : null;
    }

    public abstract boolean isListVariable();

    public abstract boolean isChained();

    public abstract boolean isNullable();

    public abstract boolean acceptsValueType(Class<?> var1);

    public boolean hasMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter != null;
    }

    public SelectionFilter<Solution_, Object> getMovableChainedTrailingValueFilter() {
        return this.movableChainedTrailingValueFilter;
    }

    public ValueRangeDescriptor<Solution_> getValueRangeDescriptor() {
        return this.valueRangeDescriptor;
    }

    public boolean isValueRangeEntityIndependent() {
        return this.valueRangeDescriptor.isEntityIndependent();
    }

    public abstract boolean isInitialized(Object var1);

    @Override
    public boolean isGenuineAndUninitialized(Object entity) {
        return !this.isInitialized(entity);
    }

    public boolean isReinitializable(Object entity) {
        Object value = this.getValue(entity);
        return value == null;
    }

    public SelectionSorter<Solution_, Object> getIncreasingStrengthSorter() {
        return this.increasingStrengthSorter;
    }

    public SelectionSorter<Solution_, Object> getDecreasingStrengthSorter() {
        return this.decreasingStrengthSorter;
    }

    public long getValueCount(Solution_ solution, Object entity) {
        if (!this.valueRangeDescriptor.isCountable()) {
            return 0L;
        }
        return ((CountableValueRange)this.valueRangeDescriptor.extractValueRange(solution, entity)).getSize();
    }

    public String toString() {
        return this.getSimpleEntityAndVariableName() + " variable";
    }
}

