/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.domain.solution.cloner;

import ai.timefold.solver.core.api.domain.solution.cloner.DeepPlanningClone;
import ai.timefold.solver.core.api.domain.variable.PlanningListVariable;
import ai.timefold.solver.core.api.score.Score;
import ai.timefold.solver.core.impl.domain.common.ReflectionHelper;
import ai.timefold.solver.core.impl.domain.solution.descriptor.SolutionDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;

public final class DeepCloningUtils {
    private static final Set<Class<?>> IMMUTABLE_CLASSES = Set.of(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, Optional.class, OptionalInt.class, OptionalLong.class, OptionalDouble.class, Duration.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneId.class, ZoneOffset.class, Boolean.class, Character.class, String.class, UUID.class);

    public static boolean isDeepCloned(SolutionDescriptor<?> solutionDescriptor, Field field, Class<?> owningClass, Class<?> actualValueClass) {
        return DeepCloningUtils.isClassDeepCloned(solutionDescriptor, actualValueClass) || DeepCloningUtils.isFieldDeepCloned(solutionDescriptor, field, owningClass);
    }

    public static boolean isFieldDeepCloned(SolutionDescriptor<?> solutionDescriptor, Field field, Class<?> owningClass) {
        Class<?> fieldType = field.getType();
        if (DeepCloningUtils.isImmutable(fieldType)) {
            return false;
        }
        return DeepCloningUtils.isFieldAnEntityPropertyOnSolution(solutionDescriptor, field, owningClass) || DeepCloningUtils.isFieldAnEntityOrSolution(solutionDescriptor, field) || DeepCloningUtils.isFieldAPlanningListVariable(field, owningClass) || DeepCloningUtils.isFieldADeepCloneProperty(field, owningClass);
    }

    static boolean isImmutable(Class<?> clz) {
        if (clz.isPrimitive() || clz.isEnum() || Score.class.isAssignableFrom(clz)) {
            return true;
        }
        return IMMUTABLE_CLASSES.contains(clz);
    }

    static boolean isFieldAnEntityPropertyOnSolution(SolutionDescriptor<?> solutionDescriptor, Field field, Class<?> owningClass) {
        if (!solutionDescriptor.getSolutionClass().isAssignableFrom(owningClass)) {
            return false;
        }
        String fieldName = field.getName();
        if (solutionDescriptor.getEntityMemberAccessorMap().get(fieldName) != null) {
            return true;
        }
        return solutionDescriptor.getEntityCollectionMemberAccessorMap().get(fieldName) != null;
    }

    private static boolean isFieldAnEntityOrSolution(SolutionDescriptor<?> solutionDescriptor, Field field) {
        Class<?> type = field.getType();
        if (DeepCloningUtils.isClassDeepCloned(solutionDescriptor, type)) {
            return true;
        }
        if (Collection.class.isAssignableFrom(type) || Map.class.isAssignableFrom(type)) {
            return DeepCloningUtils.isTypeArgumentDeepCloned(solutionDescriptor, field.getGenericType());
        }
        if (type.isArray()) {
            return DeepCloningUtils.isClassDeepCloned(solutionDescriptor, type.getComponentType());
        }
        return false;
    }

    public static boolean isClassDeepCloned(SolutionDescriptor<?> solutionDescriptor, Class<?> type) {
        if (DeepCloningUtils.isImmutable(type)) {
            return false;
        }
        return solutionDescriptor.hasEntityDescriptor(type) || solutionDescriptor.getSolutionClass().isAssignableFrom(type) || type.isAnnotationPresent(DeepPlanningClone.class);
    }

    private static boolean isTypeArgumentDeepCloned(SolutionDescriptor<?> solutionDescriptor, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            for (Type actualTypeArgument : parameterizedType.getActualTypeArguments()) {
                if (actualTypeArgument instanceof Class && DeepCloningUtils.isClassDeepCloned(solutionDescriptor, (Class)actualTypeArgument)) {
                    return true;
                }
                if (!DeepCloningUtils.isTypeArgumentDeepCloned(solutionDescriptor, actualTypeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isFieldADeepCloneProperty(Field field, Class<?> owningClass) {
        if (field.isAnnotationPresent(DeepPlanningClone.class)) {
            return true;
        }
        Method getterMethod = ReflectionHelper.getGetterMethod(owningClass, field.getName());
        return getterMethod != null && getterMethod.isAnnotationPresent(DeepPlanningClone.class);
    }

    private static boolean isFieldAPlanningListVariable(Field field, Class<?> owningClass) {
        if (!field.isAnnotationPresent(PlanningListVariable.class)) {
            Method getterMethod = ReflectionHelper.getGetterMethod(owningClass, field.getName());
            return getterMethod != null && getterMethod.isAnnotationPresent(PlanningListVariable.class);
        }
        return true;
    }

    private DeepCloningUtils() {
    }
}

