/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.impl.constructionheuristic.placer;

import ai.timefold.solver.core.config.constructionheuristic.placer.QueuedEntityPlacerConfig;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionCacheType;
import ai.timefold.solver.core.config.heuristic.selector.common.SelectionOrder;
import ai.timefold.solver.core.config.heuristic.selector.entity.EntitySelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.MoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.composite.CartesianProductMoveSelectorConfig;
import ai.timefold.solver.core.config.heuristic.selector.move.generic.ChangeMoveSelectorConfig;
import ai.timefold.solver.core.config.util.ConfigUtils;
import ai.timefold.solver.core.impl.constructionheuristic.placer.AbstractEntityPlacerFactory;
import ai.timefold.solver.core.impl.constructionheuristic.placer.QueuedEntityPlacer;
import ai.timefold.solver.core.impl.domain.entity.descriptor.EntityDescriptor;
import ai.timefold.solver.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import ai.timefold.solver.core.impl.heuristic.HeuristicConfigPolicy;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelector;
import ai.timefold.solver.core.impl.heuristic.selector.entity.EntitySelectorFactory;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelector;
import ai.timefold.solver.core.impl.heuristic.selector.move.MoveSelectorFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueuedEntityPlacerFactory<Solution_>
extends AbstractEntityPlacerFactory<Solution_, QueuedEntityPlacerConfig> {
    public static <Solution_> QueuedEntityPlacerConfig unfoldNew(HeuristicConfigPolicy<Solution_> configPolicy, List<MoveSelectorConfig> templateMoveSelectorConfigList) {
        QueuedEntityPlacerConfig config = new QueuedEntityPlacerConfig();
        config.setEntitySelectorConfig(new QueuedEntityPlacerFactory<Solution_>(config).buildEntitySelectorConfig(configPolicy));
        config.setMoveSelectorConfigList(new ArrayList<MoveSelectorConfig>(templateMoveSelectorConfigList.size()));
        ArrayList<MoveSelectorConfig> leafMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(templateMoveSelectorConfigList.size());
        for (MoveSelectorConfig moveSelectorConfig : templateMoveSelectorConfigList) {
            MoveSelectorConfig moveSelectorConfig2 = (MoveSelectorConfig)moveSelectorConfig.copyConfig();
            moveSelectorConfig2.extractLeafMoveSelectorConfigsIntoList(leafMoveSelectorConfigList);
            config.getMoveSelectorConfigList().add(moveSelectorConfig2);
        }
        for (MoveSelectorConfig<Object> moveSelectorConfig : leafMoveSelectorConfigList) {
            if (!(moveSelectorConfig instanceof ChangeMoveSelectorConfig)) {
                throw new IllegalStateException("The <constructionHeuristic> contains a moveSelector (" + moveSelectorConfig + ") that isn't a <changeMoveSelector>, a <unionMoveSelector> or a <cartesianProductMoveSelector>.\nMaybe you're using a moveSelector in <constructionHeuristic> that's only supported for <localSearch>.");
            }
            ChangeMoveSelectorConfig changeMoveSelectorConfig = (ChangeMoveSelectorConfig)moveSelectorConfig;
            if (changeMoveSelectorConfig.getEntitySelectorConfig() != null) {
                throw new IllegalStateException("The <constructionHeuristic> contains a changeMoveSelector (" + changeMoveSelectorConfig + ") that contains an entitySelector (" + changeMoveSelectorConfig.getEntitySelectorConfig() + ") without explicitly configuring the <queuedEntityPlacer>.");
            }
            changeMoveSelectorConfig.setEntitySelectorConfig(EntitySelectorConfig.newMimicSelectorConfig(config.getEntitySelectorConfig().getId()));
        }
        return config;
    }

    public QueuedEntityPlacerFactory(QueuedEntityPlacerConfig placerConfig) {
        super(placerConfig);
    }

    @Override
    public QueuedEntityPlacer<Solution_> buildEntityPlacer(HeuristicConfigPolicy<Solution_> configPolicy) {
        List<MoveSelectorConfig> moveSelectorConfigList_;
        EntitySelectorConfig entitySelectorConfig_ = this.buildEntitySelectorConfig(configPolicy);
        EntitySelector entitySelector = EntitySelectorFactory.create(entitySelectorConfig_).buildEntitySelector(configPolicy, SelectionCacheType.PHASE, SelectionOrder.ORIGINAL);
        if (ConfigUtils.isEmptyCollection(((QueuedEntityPlacerConfig)this.config).getMoveSelectorConfigList())) {
            EntityDescriptor entityDescriptor = entitySelector.getEntityDescriptor();
            List variableDescriptorList = entityDescriptor.getGenuineVariableDescriptorList();
            ArrayList<MoveSelectorConfig> subMoveSelectorConfigList = new ArrayList<MoveSelectorConfig>(variableDescriptorList.size());
            for (GenuineVariableDescriptor variableDescriptor : variableDescriptorList) {
                subMoveSelectorConfigList.add(this.buildChangeMoveSelectorConfig(configPolicy, entitySelectorConfig_.getId(), variableDescriptor));
            }
            MoveSelectorConfig subMoveSelectorConfig = subMoveSelectorConfigList.size() > 1 ? new CartesianProductMoveSelectorConfig(subMoveSelectorConfigList) : (MoveSelectorConfig)subMoveSelectorConfigList.get(0);
            moveSelectorConfigList_ = Collections.singletonList(subMoveSelectorConfig);
        } else {
            moveSelectorConfigList_ = ((QueuedEntityPlacerConfig)this.config).getMoveSelectorConfigList();
        }
        ArrayList moveSelectorList = new ArrayList(moveSelectorConfigList_.size());
        for (MoveSelectorConfig moveSelectorConfig : moveSelectorConfigList_) {
            MoveSelector moveSelector = MoveSelectorFactory.create(moveSelectorConfig).buildMoveSelector(configPolicy, SelectionCacheType.JUST_IN_TIME, SelectionOrder.ORIGINAL);
            moveSelectorList.add(moveSelector);
        }
        return new QueuedEntityPlacer(entitySelector, moveSelectorList);
    }

    public EntitySelectorConfig buildEntitySelectorConfig(HeuristicConfigPolicy<Solution_> configPolicy) {
        EntitySelectorConfig entitySelectorConfig_;
        if (((QueuedEntityPlacerConfig)this.config).getEntitySelectorConfig() == null) {
            EntityDescriptor<Solution_> entityDescriptor = this.getTheOnlyEntityDescriptor(configPolicy.getSolutionDescriptor());
            entitySelectorConfig_ = QueuedEntityPlacerFactory.getDefaultEntitySelectorConfigForEntity(configPolicy, entityDescriptor);
        } else {
            entitySelectorConfig_ = ((QueuedEntityPlacerConfig)this.config).getEntitySelectorConfig();
        }
        if (entitySelectorConfig_.getCacheType() != null && entitySelectorConfig_.getCacheType().compareTo(SelectionCacheType.PHASE) < 0) {
            throw new IllegalArgumentException("The queuedEntityPlacer (" + this.config + ") cannot have an entitySelectorConfig (" + entitySelectorConfig_ + ") with a cacheType (" + entitySelectorConfig_.getCacheType() + ") lower than " + SelectionCacheType.PHASE + ".");
        }
        return entitySelectorConfig_;
    }
}

