/*
 * Decompiled with CFR 0.152.
 */
package ai.timefold.solver.core.config.heuristic.selector.common;

import javax.xml.bind.annotation.XmlEnum;

@XmlEnum
public enum SelectionCacheType {
    JUST_IN_TIME,
    STEP,
    PHASE,
    SOLVER;


    public static SelectionCacheType resolve(SelectionCacheType cacheType, SelectionCacheType minimumCacheType) {
        if (cacheType == null) {
            return JUST_IN_TIME;
        }
        if (cacheType != JUST_IN_TIME && cacheType.compareTo(minimumCacheType) < 0) {
            throw new IllegalArgumentException("The cacheType (" + cacheType + ") is wasteful because an ancestor has a higher cacheType (" + minimumCacheType + ").");
        }
        return cacheType;
    }

    public boolean isCached() {
        switch (this) {
            case JUST_IN_TIME: {
                return false;
            }
            case STEP: 
            case PHASE: 
            case SOLVER: {
                return true;
            }
        }
        throw new IllegalStateException("The cacheType (" + this + ") is not implemented.");
    }

    public boolean isNotCached() {
        return !this.isCached();
    }

    public static SelectionCacheType max(SelectionCacheType a, SelectionCacheType b) {
        if (a.compareTo(b) >= 0) {
            return a;
        }
        return b;
    }
}

